/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.sql.SQLException;
import java.util.Map;
import org.modeshape.persistence.relational.DefaultStatements;
import org.modeshape.persistence.relational.RelationalDbConfig;

public class OracleStatements
extends DefaultStatements {
    protected OracleStatements(RelationalDbConfig config, Map<String, String> statements) {
        super(config, statements);
    }

    @Override
    protected void processSQLException(String statementId, SQLException e) throws SQLException {
        int errorCode = e.getErrorCode();
        if (errorCode == 955 && "create_table".equals(statementId)) {
            this.logTableInfo("Table {0} already exists");
        } else if (errorCode == 942 && "delete_table".equals(statementId)) {
            this.logTableInfo("Table {0} does not exist");
        } else {
            throw e;
        }
    }
}

