/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.modeshape.common.util.StringUtil;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.document.EditableDocument;
import org.modeshape.schematic.document.Editor;

public final class RelationalDbConfig {
    public static final String ALIAS1 = "db";
    public static List<String> ALIASES = Arrays.asList("db", "database");
    public static final String DROP_ON_EXIT = "dropOnExit";
    public static final String CREATE_ON_START = "createOnStart";
    public static final String TABLE_NAME = "tableName";
    public static final String FETCH_SIZE = "fetchSize";
    public static final String COMPRESS = "compress";
    public static final String CONNECTION_URL = "connectionUrl";
    public static final String DRIVER = "driver";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String DATASOURCE_JNDI_NAME = "dataSourceJndiName";
    public static final String POOL_SIZE = "poolSize";
    protected static final List<String> ALL_FIELDS = Arrays.asList("type", "dropOnExit", "createOnStart", "tableName", "fetchSize", "compress", "connectionUrl", "driver", "username", "password", "dataSourceJndiName", "poolSize");
    protected static final String DEFAULT_CONNECTION_URL = "jdbc:h2:mem:modeshape;DB_CLOSE_DELAY=0;MVCC=TRUE";
    protected static final String DEFAULT_DRIVER = "org.h2.Driver";
    protected static final String DEFAULT_USERNAME = "sa";
    protected static final String DEFAULT_PASSWORD = "";
    protected static final String DEFAULT_TABLE_NAME = "MODESHAPE_REPOSITORY";
    protected static final String DEFAULT_MAX_POOL_SIZE = "5";
    protected static final String DEFAULT_MIN_IDLE = "1";
    protected static final String DEFAULT_IDLE_TIMEOUT = String.valueOf(TimeUnit.MINUTES.toMillis(1L));
    protected static final int DEFAULT_FETCH_SIZE = 1000;
    private final Document config;
    private final boolean createOnStart;
    private final boolean dropOnExit;
    private final String tableName;
    private final int fetchSize;
    private final boolean compress;
    private final String connectionUrl;
    private final String datasourceJNDIName;

    protected RelationalDbConfig(Document document) {
        this.config = document;
        this.datasourceJNDIName = this.config.getString(DATASOURCE_JNDI_NAME, null);
        this.createOnStart = this.propertyAsBoolean(this.config, CREATE_ON_START, true);
        this.dropOnExit = this.propertyAsBoolean(this.config, DROP_ON_EXIT, false);
        this.tableName = this.config.getString(TABLE_NAME, DEFAULT_TABLE_NAME);
        this.fetchSize = this.propertyAsInt(this.config, FETCH_SIZE, 1000);
        this.compress = this.propertyAsBoolean(this.config, COMPRESS, false);
        this.connectionUrl = this.config.getString(CONNECTION_URL, DEFAULT_CONNECTION_URL);
    }

    protected boolean isDatasourceManaged() {
        return !StringUtil.isBlank((String)this.datasourceJNDIName);
    }

    protected Properties datasourceConfig() {
        Properties datasourceCfg = new Properties();
        Editor localCopy = this.config.edit(true);
        ALL_FIELDS.forEach(arg_0 -> ((EditableDocument)localCopy).remove(arg_0));
        datasourceCfg.setProperty("jdbcUrl", this.connectionUrl);
        datasourceCfg.setProperty("driverClassName", this.config.getString(DRIVER, DEFAULT_DRIVER));
        datasourceCfg.setProperty(USERNAME, this.config.getString(USERNAME, DEFAULT_USERNAME));
        datasourceCfg.setProperty(PASSWORD, this.config.getString(PASSWORD, DEFAULT_PASSWORD));
        datasourceCfg.setProperty("maximumPoolSize", this.propertyAsString(this.config, POOL_SIZE, DEFAULT_MAX_POOL_SIZE));
        datasourceCfg.setProperty("minimumIdle", DEFAULT_MIN_IDLE);
        datasourceCfg.setProperty("idleTimeout", DEFAULT_IDLE_TIMEOUT);
        localCopy.fields().forEach(field -> datasourceCfg.setProperty(field.getName(), field.getValue().toString()));
        return datasourceCfg;
    }

    protected String name() {
        return this.datasourceJNDIName != null ? this.datasourceJNDIName : this.connectionUrl;
    }

    protected String datasourceJNDIName() {
        return this.datasourceJNDIName;
    }

    protected boolean createOnStart() {
        return this.createOnStart;
    }

    protected boolean dropOnExit() {
        return this.dropOnExit;
    }

    protected String tableName() {
        return this.tableName;
    }

    protected int fetchSize() {
        return this.fetchSize;
    }

    protected boolean compress() {
        return this.compress;
    }

    private String propertyAsString(Document document, String fieldName, String defaultValue) {
        Object value = document.get(fieldName);
        return value == null ? defaultValue : value.toString();
    }

    private int propertyAsInt(Document document, String propertyName, int defaultValue) {
        Object value = document.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    private boolean propertyAsBoolean(Document document, String propertyName, boolean defaultValue) {
        Object value = document.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }
}

