/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.persistence.relational;

import java.util.Optional;
import org.modeshape.persistence.relational.RelationalProviderException;
import org.modeshape.persistence.relational.RelationalProviderI18n;

public final class TransactionsHolder {
    private static final ThreadLocal<String> ACTIVE_TX_ID = new ThreadLocal();

    private TransactionsHolder() {
    }

    protected static boolean hasActiveTransaction() {
        return TransactionsHolder.activeTransaction() != null;
    }

    protected static String requireActiveTransaction() {
        return Optional.ofNullable(ACTIVE_TX_ID.get()).orElseThrow(() -> new RelationalProviderException(RelationalProviderI18n.threadNotAssociatedWithTransaction, Thread.currentThread().getName()));
    }

    protected static void setActiveTxId(String txId) {
        ACTIVE_TX_ID.set(txId);
    }

    protected static String activeTransaction() {
        return ACTIVE_TX_ID.get();
    }

    protected static void clearActiveTransaction() {
        ACTIVE_TX_ID.remove();
    }
}

