/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.repository.sequencer;

import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.property.DateTime;

@NotThreadSafe
public class SequencerContext {
    private final ExecutionContext executionContext;
    private final Graph sourceGraph;
    private final Graph destinationGraph;
    private final Destination destination;
    private final DateTime timestamp;

    public SequencerContext(ExecutionContext executionContext, Graph sourceGraph, Graph outputGraph, DateTime timestamp) {
        assert (executionContext != null);
        assert (sourceGraph != null);
        assert (timestamp != null);
        this.executionContext = executionContext;
        this.sourceGraph = sourceGraph;
        this.destinationGraph = outputGraph != null ? outputGraph : sourceGraph;
        this.destination = new GraphBatchDestination(this.destinationGraph.batch());
        this.timestamp = timestamp;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public Destination getDestination() {
        return this.destination;
    }

    Graph graph() {
        return this.sourceGraph;
    }

    Graph destinationGraph() {
        return this.destinationGraph;
    }
}

