/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.context.FlagContainer;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.internal.ImmutableSchematicValue;
import org.infinispan.schematic.internal.SchematicEntryLiteral;

public class SchematicEntryLookup {
    public static SchematicEntry getSchematicValue(Cache<String, SchematicEntry> cache, String key) {
        return SchematicEntryLookup.getSchematicValue(cache, key, true, null);
    }

    public static SchematicEntry getSchematicValue(Cache<String, SchematicEntry> cache, String key, boolean createIfAbsent) {
        return SchematicEntryLookup.getSchematicValue(cache, key, createIfAbsent, null);
    }

    public static SchematicEntry getSchematicValue(Cache<String, SchematicEntry> cache, String key, FlagContainer flagContainer) {
        return SchematicEntryLookup.getSchematicValue(cache, key, true, flagContainer);
    }

    private static final SchematicEntry getSchematicValue(Cache<String, SchematicEntry> cache, String key, boolean createIfAbsent, FlagContainer flagContainer) {
        SchematicEntry value = (SchematicEntry)cache.get((Object)key);
        if (value == null) {
            if (createIfAbsent) {
                value = SchematicEntryLiteral.newInstance(cache, key);
            } else {
                return null;
            }
        }
        SchematicEntryLiteral castValue = (SchematicEntryLiteral)value;
        AdvancedCache advCache = cache.getAdvancedCache();
        return castValue.getProxy((Cache<String, SchematicEntry>)advCache, key, flagContainer);
    }

    public static SchematicEntry getReadOnlySchematicValue(Cache<String, SchematicEntry> cache, String key) {
        SchematicEntry existingValue = SchematicEntryLookup.getSchematicValue(cache, key, false, null);
        if (existingValue == null) {
            existingValue = new SchematicEntryLiteral(key);
        }
        return new ImmutableSchematicValue(existingValue);
    }

    public static void removeSchematicValue(Cache<String, SchematicEntry> cache, String key) {
        cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD}).remove((Object)key);
    }
}

