/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.search.lucene;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Field;
import org.modeshape.common.text.FilenameEncoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.basic.JodaDateTime;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RequestType;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.UpdateValuesRequest;
import org.modeshape.graph.search.AbstractSearchEngine;
import org.modeshape.graph.search.SearchEngine;
import org.modeshape.graph.search.SearchEngineException;
import org.modeshape.graph.search.SearchEngineIndexer;
import org.modeshape.search.lucene.AbstractLuceneSearchEngine;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneConfiguration;
import org.modeshape.search.lucene.LuceneConfigurations;
import org.modeshape.search.lucene.LuceneSearchProcessor;
import org.modeshape.search.lucene.LuceneSearchWorkspace;

public class LuceneSearchEngine
extends AbstractLuceneSearchEngine<LuceneSearchWorkspace, LuceneSearchProcessor> {
    public static final IndexRules DEFAULT_RULES;
    protected static final TextEncoder DEFAULT_ENCODER;
    protected ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
        }
    };
    private final LuceneConfiguration configuration;
    private final IndexRules rules;
    private final Analyzer analyzer;
    private final int maxDepthPerIndexRead;

    public LuceneSearchEngine(String sourceName, RepositoryConnectionFactory connectionFactory, boolean verifyWorkspaceInSource, int maxDepthPerIndexRead, LuceneConfiguration configuration, IndexRules rules, Analyzer analyzer) {
        super(sourceName, connectionFactory, verifyWorkspaceInSource);
        CheckArg.isNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        this.analyzer = analyzer != null ? analyzer : new StandardAnalyzer(configuration.getVersion());
        this.rules = rules != null ? rules : DEFAULT_RULES;
        this.maxDepthPerIndexRead = maxDepthPerIndexRead;
    }

    public LuceneSearchEngine(String sourceName, RepositoryConnectionFactory connectionFactory, boolean verifyWorkspaceInSource, int maxDepthPerIndexRead, File indexStorageDirectory, IndexRules rules, Analyzer analyzer) {
        this(sourceName, connectionFactory, verifyWorkspaceInSource, maxDepthPerIndexRead, LuceneConfigurations.using(indexStorageDirectory, null, DEFAULT_ENCODER, DEFAULT_ENCODER), null, null);
    }

    public LuceneSearchEngine(String sourceName, RepositoryConnectionFactory connectionFactory, boolean verifyWorkspaceInSource, int maxDepthPerIndexRead, IndexRules rules, Analyzer analyzer) {
        this(sourceName, connectionFactory, verifyWorkspaceInSource, maxDepthPerIndexRead, LuceneConfigurations.inMemory(), null, null);
    }

    protected LuceneSearchProcessor createProcessor(ExecutionContext context, AbstractSearchEngine.Workspaces<LuceneSearchWorkspace> workspaces, Observer observer, boolean readOnly) {
        return new LuceneSearchProcessor(this.getSourceName(), context, workspaces, observer, null, readOnly);
    }

    protected LuceneSearchWorkspace createWorkspace(ExecutionContext context, String workspaceName) throws SearchEngineException {
        return new LuceneSearchWorkspace(workspaceName, this.configuration, this.rules, this.analyzer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(ExecutionContext context, Iterable<ChangeRequest> changes) throws SearchEngineException {
        WorkForWorkspaces allWork = new WorkForWorkspaces(context);
        for (ChangeRequest change : changes) {
            WorkspaceWork work = allWork.forWorkspace(change.changedWorkspace());
            assert (work != null);
            if (work.add(change)) continue;
            break;
        }
        SearchEngineIndexer indexer = new SearchEngineIndexer(context, (SearchEngine)this, this.getConnectionFactory(), this.maxDepthPerIndexRead);
        try {
            for (WorkspaceWork workspaceWork : allWork) {
                if (workspaceWork.indexAllContent) {
                    indexer.index(workspaceWork.workspaceName);
                    continue;
                }
                if (workspaceWork.deleteWorkspace) {
                    indexer.process((ChangeRequest)new DestroyWorkspaceRequest(workspaceWork.workspaceName));
                    continue;
                }
                for (WorkRequest request : workspaceWork) {
                    if (request instanceof CrawlSubgraph) {
                        CrawlSubgraph crawlRequest = (CrawlSubgraph)request;
                        Location location = crawlRequest.location;
                        indexer.index(workspaceWork.workspaceName, location, crawlRequest.depth);
                        continue;
                    }
                    if (!(request instanceof ForwardRequest)) continue;
                    ForwardRequest forwardRequest = (ForwardRequest)request;
                    indexer.process(forwardRequest.changeRequest.clone());
                }
            }
        }
        finally {
            indexer.close();
        }
    }

    protected static ChangeRequest merge(ExecutionContext context, ChangeRequest original, ChangeRequest change) {
        assert (!original.hasError());
        assert (!change.hasError());
        if (RequestType.CREATE_NODE == original.getType()) {
            CreateNodeRequest create = (CreateNodeRequest)original;
            switch (change.getType()) {
                case CREATE_NODE: {
                    SetPropertyRequest set = (SetPropertyRequest)change;
                    Name newPropertyName = set.property().getName();
                    LinkedList<Property> newPropertiesList = new LinkedList<Property>();
                    for (Property property : create.properties()) {
                        if (property.getName().equals(newPropertyName)) continue;
                        newPropertiesList.add(property);
                    }
                    newPropertiesList.add(set.property());
                    CreateNodeRequest newRequest = new CreateNodeRequest(create.under(), create.inWorkspace(), create.named(), create.conflictBehavior(), newPropertiesList);
                    newRequest.setActualLocationOfNode(create.getActualLocationOfNode());
                    return newRequest;
                }
                case UPDATE_PROPERTIES: {
                    UpdatePropertiesRequest update = (UpdatePropertiesRequest)change;
                    HashMap<Name, Property> newProperties = new HashMap<Name, Property>();
                    for (Property property : create.properties()) {
                        newProperties.put(property.getName(), property);
                    }
                    newProperties.putAll(update.properties());
                    CreateNodeRequest newRequest = new CreateNodeRequest(create.under(), create.inWorkspace(), create.named(), create.conflictBehavior(), newProperties.values());
                    newRequest.setActualLocationOfNode(create.getActualLocationOfNode());
                    return newRequest;
                }
                case REMOVE_PROPERTY: {
                    RemovePropertyRequest remove = (RemovePropertyRequest)change;
                    HashMap<Name, Property> newProperties = new HashMap<Name, Property>();
                    for (Property property : create.properties()) {
                        newProperties.put(property.getName(), property);
                    }
                    newProperties.remove(remove.propertyName());
                    CreateNodeRequest newRequest = new CreateNodeRequest(create.under(), create.inWorkspace(), create.named(), create.conflictBehavior(), newProperties.values());
                    newRequest.setActualLocationOfNode(create.getActualLocationOfNode());
                    return newRequest;
                }
                case UPDATE_VALUES: {
                    UpdateValuesRequest updateRequest = (UpdateValuesRequest)change;
                    HashMap<Name, Property> newProperties = new HashMap<Name, Property>();
                    for (Property property : create.properties()) {
                        newProperties.put(property.getName(), property);
                    }
                    Property updated = (Property)newProperties.get(updateRequest.property());
                    if (updated != null) {
                        LinkedList newValues = new LinkedList();
                        for (Object existingValue : updated) {
                            newValues.add(existingValue);
                        }
                        newValues.removeAll(updateRequest.removedValues());
                        newValues.addAll(updateRequest.addedValues());
                        updated = context.getPropertyFactory().create(updateRequest.property(), newValues);
                    } else {
                        updated = context.getPropertyFactory().create(updateRequest.property(), (Iterable)updateRequest.addedValues());
                    }
                    newProperties.put(updated.getName(), updated);
                    CreateNodeRequest newRequest = new CreateNodeRequest(create.under(), create.inWorkspace(), create.named(), create.conflictBehavior(), newProperties.values());
                    newRequest.setActualLocationOfNode(create.getActualLocationOfNode());
                    return newRequest;
                }
            }
        }
        if (RequestType.UPDATE_PROPERTIES == original.getType()) {
            UpdatePropertiesRequest update = (UpdatePropertiesRequest)original;
            switch (change.getType()) {
                case SET_PROPERTY: {
                    SetPropertyRequest set = (SetPropertyRequest)change;
                    Property newProperty = set.property();
                    Name newPropertyName = newProperty.getName();
                    HashMap<Name, Property> newProperties = new HashMap<Name, Property>(update.properties());
                    newProperties.put(newPropertyName, newProperty);
                    UpdatePropertiesRequest newRequest = new UpdatePropertiesRequest(update.getActualLocationOfNode(), update.inWorkspace(), newProperties, update.removeOtherProperties());
                    newRequest.setActualLocationOfNode(update.getActualLocationOfNode());
                    return newRequest;
                }
                case REMOVE_PROPERTY: {
                    RemovePropertyRequest remove = (RemovePropertyRequest)change;
                    HashMap newProperties = new HashMap(update.properties());
                    newProperties.remove(remove.propertyName());
                    UpdatePropertiesRequest newRequest = new UpdatePropertiesRequest(update.getActualLocationOfNode(), update.inWorkspace(), newProperties, update.removeOtherProperties());
                    newRequest.setActualLocationOfNode(update.getActualLocationOfNode());
                    return newRequest;
                }
                case UPDATE_VALUES: {
                    UpdateValuesRequest updateValues = (UpdateValuesRequest)change;
                    HashMap<Name, Property> newProperties = new HashMap<Name, Property>(update.properties());
                    Property updated = (Property)newProperties.get(updateValues.property());
                    if (updated != null) {
                        LinkedList newValues = new LinkedList();
                        for (Object existingValue : updated) {
                            newValues.add(existingValue);
                        }
                        newValues.removeAll(updateValues.removedValues());
                        newValues.addAll(updateValues.addedValues());
                        updated = context.getPropertyFactory().create(updateValues.property(), newValues);
                    } else {
                        updated = context.getPropertyFactory().create(updateValues.property(), (Iterable)updateValues.addedValues());
                    }
                    newProperties.put(updated.getName(), updated);
                    UpdatePropertiesRequest newRequest = new UpdatePropertiesRequest(update.getActualLocationOfNode(), update.inWorkspace(), newProperties, update.removeOtherProperties());
                    newRequest.setActualLocationOfNode(update.getActualLocationOfNode());
                    return newRequest;
                }
            }
        }
        return null;
    }

    static {
        long earliestChangeDate = new JodaDateTime(2009, 11, 1, 0, 0, 0, 0).getMilliseconds();
        IndexRules.Builder builder = IndexRules.createBuilder();
        builder.defaultTo(Field.Store.YES, Field.Index.ANALYZED, true, true);
        builder.stringField(JcrLexicon.UUID, Field.Store.YES, Field.Index.NOT_ANALYZED, false, false);
        builder.stringField(ModeShapeLexicon.UUID, Field.Store.YES, Field.Index.NOT_ANALYZED, false, false);
        builder.dateField(JcrLexicon.CREATED, Field.Store.YES, Field.Index.NOT_ANALYZED, earliestChangeDate);
        builder.dateField(JcrLexicon.LAST_MODIFIED, Field.Store.YES, Field.Index.NOT_ANALYZED, earliestChangeDate);
        DEFAULT_RULES = builder.build();
        DEFAULT_ENCODER = new FilenameEncoder();
    }

    @Immutable
    protected static class ForwardRequest
    extends WorkRequest {
        protected final ChangeRequest changeRequest;

        protected ForwardRequest(ChangeRequest changeRequest) {
            this.changeRequest = changeRequest;
        }

        @Override
        public String toString(ExecutionContext context) {
            return "Forward " + this.changeRequest;
        }
    }

    @Immutable
    protected static class CrawlSubgraph
    extends WorkRequest {
        protected final Location location;
        protected final int depth;

        protected CrawlSubgraph(Location location, int depth) {
            this.location = location;
            this.depth = depth;
        }

        @Override
        public String toString(ExecutionContext context) {
            return "Crawl " + this.location.getPath().getString(context.getNamespaceRegistry());
        }
    }

    @Immutable
    protected static abstract class WorkRequest {
        protected WorkRequest() {
        }

        public abstract String toString(ExecutionContext var1);

        public String toString() {
            return this.toString(new ExecutionContext());
        }
    }

    protected static class WorkspaceWork
    implements Iterable<WorkRequest> {
        private final ExecutionContext context;
        protected final String workspaceName;
        protected final Map<Path, WorkRequest> requestByPath = new HashMap<Path, WorkRequest>();
        protected boolean indexAllContent;
        protected boolean deleteWorkspace;

        protected WorkspaceWork(ExecutionContext context, String workspaceName) {
            this.context = context;
            this.workspaceName = workspaceName;
        }

        @Override
        public Iterator<WorkRequest> iterator() {
            return this.requestByPath.values().iterator();
        }

        protected boolean add(ChangeRequest change) {
            assert (!this.indexAllContent);
            assert (!this.deleteWorkspace);
            switch (change.getType()) {
                case CLONE_WORKSPACE: 
                case CREATE_WORKSPACE: {
                    this.requestByPath.clear();
                    this.indexAllContent = true;
                    return false;
                }
                case DESTROY_WORKSPACE: {
                    this.requestByPath.clear();
                    this.deleteWorkspace = true;
                    return false;
                }
            }
            Location changedLocation = change.changedLocation();
            assert (changedLocation.hasPath());
            if (this.isCoveredByExistingCrawl(changedLocation.getPath())) {
                return true;
            }
            switch (change.getType()) {
                case UPDATE_PROPERTIES: {
                    if (this.mergeWithExistingWork(changedLocation, change)) {
                        return true;
                    }
                    UpdatePropertiesRequest update = (UpdatePropertiesRequest)change;
                    if (update.removeOtherProperties()) {
                        this.forward(changedLocation, (ChangeRequest)update);
                        return true;
                    }
                    this.crawl(update.changedLocation(), 1);
                    return true;
                }
                case SET_PROPERTY: {
                    if (this.mergeWithExistingWork(changedLocation, change)) {
                        return true;
                    }
                    this.crawl(changedLocation, 1);
                    return true;
                }
                case UPDATE_VALUES: {
                    if (this.mergeWithExistingWork(changedLocation, change)) {
                        return true;
                    }
                    this.crawl(changedLocation, 1);
                    return true;
                }
                case CREATE_NODE: {
                    this.forward(changedLocation, change);
                    return true;
                }
            }
            this.requestByPath.clear();
            this.indexAllContent = true;
            return false;
        }

        private boolean mergeWithExistingWork(Location location, ChangeRequest change) {
            ChangeRequest existingRequest;
            ChangeRequest merged;
            Path path = location.getPath();
            WorkRequest existing = this.requestByPath.get(path);
            if (existing instanceof CrawlSubgraph) {
                return true;
            }
            if (existing instanceof ForwardRequest && (merged = LuceneSearchEngine.merge(this.context, existingRequest = ((ForwardRequest)existing).changeRequest, change)) != null) {
                this.forward(location, merged);
                return true;
            }
            return false;
        }

        private void forward(Location location, ChangeRequest request) {
            this.requestByPath.put(location.getPath(), new ForwardRequest(request));
        }

        private boolean isCoveredByExistingCrawl(Path path) {
            while (!path.isRoot()) {
                WorkRequest existing = this.requestByPath.get(path = path.getParent());
                if (existing == null || !(existing instanceof CrawlSubgraph)) continue;
                CrawlSubgraph crawl = (CrawlSubgraph)existing;
                if (crawl.depth == 1) continue;
                return true;
            }
            return false;
        }

        private void crawl(Location location, int depth) {
            Path path = location.getPath();
            Iterator<Map.Entry<Path, WorkRequest>> iter = this.requestByPath.entrySet().iterator();
            while (iter.hasNext()) {
                if (!iter.next().getKey().isDecendantOf(path)) continue;
                iter.remove();
            }
            this.requestByPath.put(path, new CrawlSubgraph(location, depth));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("  Workspace: ").append(this.workspaceName).append('\n');
            for (Map.Entry<Path, WorkRequest> entry : this.requestByPath.entrySet()) {
                sb.append("    ").append(entry.getKey().getString(this.context.getNamespaceRegistry())).append("->").append(entry.getValue().toString(this.context)).append('\n');
            }
            return sb.toString();
        }
    }

    protected static class WorkForWorkspaces
    implements Iterable<WorkspaceWork> {
        private Map<String, WorkspaceWork> byWorkspaceName = new HashMap<String, WorkspaceWork>();
        private final ExecutionContext context;

        protected WorkForWorkspaces(ExecutionContext context) {
            this.context = context;
        }

        protected WorkspaceWork forWorkspace(String workspaceName) {
            WorkspaceWork work = this.byWorkspaceName.get(workspaceName);
            if (work == null) {
                work = new WorkspaceWork(this.context, workspaceName);
                this.byWorkspaceName.put(workspaceName, work);
            }
            return work;
        }

        @Override
        public Iterator<WorkspaceWork> iterator() {
            return this.byWorkspaceName.values().iterator();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (WorkspaceWork work : this.byWorkspaceName.values()) {
                sb.append(work.toString()).append('\n');
            }
            return sb.toString();
        }
    }
}

