/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.mysql;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlParserTestHelper;
import org.modeshape.sequencer.ddl.StandardDdlLexicon;
import org.modeshape.sequencer.ddl.dialect.mysql.MySqlDdlLexicon;
import org.modeshape.sequencer.ddl.dialect.mysql.MySqlDdlParser;

public class MySqlDdlParserTest
extends DdlParserTestHelper {
    public static final String DDL_FILE_PATH = "src/test/resources/ddl/dialect/mysql/";

    @Before
    public void beforeEach() {
        this.parser = new MySqlDdlParser();
        this.setPrintToConsole(false);
        this.parser.setTestMode(this.isPrintToConsole());
        this.parser.setDoUseTerminator(true);
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
        this.scorer = new DdlParserScorer();
    }

    @Test
    public void shouldParseCreateTable() {
        this.printTest("shouldParseCreateTable()");
        String content = "CREATE TABLE MY_TABLE_A (PARTID BLOB (255) NOT NULL DEFAULT (100),  -- COLUMN 1 COMMENT with comma \nPARTCOLOR INTEGER NOT NULL) ON COMMIT DELETE ROWS;";
        this.assertScoreAndParse(content, null, 2);
    }

    @Test
    @FixFor(value={"MODE-820"})
    public void shouldParseCreateTableWithKilobyteInSize() {
        this.printTest("shouldParseCreateTableWithKilobyteInSize()");
        String content = "CREATE TABLE MY_TABLE_A (PARTID BLOB (2K) NOT NULL,  -- COLUMN 1 COMMENT with comma \nPARTCOLOR CHAR(4M) NOT NULL) ON COMMIT DELETE ROWS;";
        this.assertScoreAndParse(content, null, 2);
    }

    @Test
    public void shouldParseCreateTableWithMySqlDataTypes() {
        this.printTest("shouldParseAlterTableAlterColumnDefaultRealNumber()");
        String content = "CREATE TABLE CS_EXT_FILES  (\n     FILE_NAME        VARCHAR(255),\n     FILE_CONTENTS    LONGBLOB,\n     CONFIG_CONTENTS\tLONGTEXT);";
        this.assertScoreAndParse(content, null, 1);
        Assert.assertThat((Object)this.rootNode.getChild(0).getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.rootNode.getChild(0).getName().getString(), (Matcher)Is.is((Object)"CS_EXT_FILES"));
    }

    @Test
    public void shouldParseTestCreate() {
        this.printTest("shouldParseTestCreate()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/mysql/mysql_test_create.ddl");
        this.assertScoreAndParse(content, "mysql_test_create.ddl", 145);
        List problems = this.parser.nodeFactory().getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_PROBLEM);
        Assert.assertThat((Object)problems.size(), (Matcher)Is.is((Object)0));
        List createTables = this.parser.nodeFactory().getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        Assert.assertThat((Object)createTables.size(), (Matcher)Is.is((Object)57));
        List alterTables = this.parser.nodeFactory().getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT);
        Assert.assertThat((Object)alterTables.size(), (Matcher)Is.is((Object)31));
        List createViews = this.parser.nodeFactory().getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_CREATE_VIEW_STATEMENT);
        Assert.assertThat((Object)createViews.size(), (Matcher)Is.is((Object)3));
        List createIndexes = this.parser.nodeFactory().getChildrenForType(this.rootNode, MySqlDdlLexicon.TYPE_CREATE_INDEX_STATEMENT);
        Assert.assertThat((Object)createIndexes.size(), (Matcher)Is.is((Object)53));
        List insertIntos = this.parser.nodeFactory().getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_INSERT_STATEMENT);
        Assert.assertThat((Object)insertIntos.size(), (Matcher)Is.is((Object)1));
    }

    public void shouldParseMySqlTestStatements() {
        this.printTest("shouldParseMySqlTestStatements()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/mysql/mysql_test_statements.ddl");
        this.assertScoreAndParse(content, "mysql_test_statements.ddl", 106);
        this.printUnknownStatements(this.parser, this.rootNode);
        this.printProblems(this.parser, this.rootNode);
        List problems = this.parser.nodeFactory().getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_PROBLEM);
        Assert.assertThat((Object)problems.size(), (Matcher)Is.is((Object)0));
    }
}

