/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.image;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifIFD0Descriptor;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.image.ImageMetadata;

public class ImageMetadataSequencer
extends Sequencer {
    private static final int[] EXIF_TAGS = new int[]{315, 33432, 306, 270, 271, 272, 296, 305, 282, 283, 274};
    private static final String TIFF_FORMAT = "TIFF";
    private static final String[] TIFF_MIME_TYPES = new String[]{"image/tiff", "image/x-tiff", "image/tif", "image/x-tif", "application/tif", "application/x-tif", "application/tiff", "application/x-tiff"};
    private static final String IMAGE_TIFF_DEFAULT_MIME_TYPE = TIFF_MIME_TYPES[0];

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        Node imageNode = this.getImageMetadataNode(outputNode);
        boolean imageParsedUsingDefaultMetadata = this.processUsingDefaultMetadata(imageNode, binaryValue);
        return this.processUsingAdvancedMetadata(imageNode, binaryValue, imageParsedUsingDefaultMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUsingAdvancedMetadata(Node imageNode, Binary binaryValue, boolean imageParsedUsingDefaultMetadata) throws Exception {
        try (InputStream stream = binaryValue.getStream();){
            Metadata advancedMetadata = ImageMetadataReader.readMetadata((BufferedInputStream)new BufferedInputStream(stream), (boolean)false);
            ExifIFD0Directory exifIFD0Directory = (ExifIFD0Directory)advancedMetadata.getDirectory(ExifIFD0Directory.class);
            if (exifIFD0Directory == null || !this.hasTags((Directory)exifIFD0Directory, EXIF_TAGS)) {
                if (!imageParsedUsingDefaultMetadata) {
                    this.getLogger().info("Neither default nor advanced metadata parser can resolve image. Ignoring sequencing", new Object[0]);
                }
                this.getLogger().debug("No relevant IFD0 information found, ignoring EXIF node.", new Object[0]);
                boolean bl = imageParsedUsingDefaultMetadata;
                return bl;
            }
            if (!imageParsedUsingDefaultMetadata) {
                this.getLogger().info("Image has IFD0 block information but is not one of the standard image types, marking it as TIFF", new Object[0]);
                imageNode.setProperty("image:formatName", TIFF_FORMAT);
                imageNode.setProperty("jcr:mimeType", IMAGE_TIFF_DEFAULT_MIME_TYPE);
            }
            this.addEXIFNode(imageNode, exifIFD0Directory);
            boolean bl = true;
            return bl;
        }
    }

    private void addEXIFNode(Node imageNode, ExifIFD0Directory exifIFD0Directory) throws RepositoryException {
        ExifIFD0Descriptor exifDescriptor = new ExifIFD0Descriptor(exifIFD0Directory);
        Node exifNode = imageNode.addNode("image:exif", "image:exif");
        this.setStringIfTagPresent(exifNode, "image:artist", (Directory)exifIFD0Directory, 315);
        this.setStringIfTagPresent(exifNode, "image:copyright", (Directory)exifIFD0Directory, 33432);
        this.setStringIfTagPresent(exifNode, "image:description", (Directory)exifIFD0Directory, 270);
        this.setStringIfTagPresent(exifNode, "image:make", (Directory)exifIFD0Directory, 271);
        this.setStringIfTagPresent(exifNode, "image:model", (Directory)exifIFD0Directory, 272);
        this.setStringIfTagPresent(exifNode, "image:software", (Directory)exifIFD0Directory, 305);
        this.setStringIfTagPresent(exifNode, "image:datetime", (Directory)exifIFD0Directory, 306);
        this.setStringIfNotBlank(exifNode, "image:unit", exifDescriptor.getResolutionDescription());
        this.setStringIfNotBlank(exifNode, "image:orientation", exifDescriptor.getOrientationDescription());
        this.setDoubleIfTagPresent(exifNode, "image:resolution_x", (Directory)exifIFD0Directory, 282);
        this.setDoubleIfTagPresent(exifNode, "image:resolution_y", (Directory)exifIFD0Directory, 283);
    }

    private void setStringIfTagPresent(Node node, String propertyName, Directory directory, int tag) throws RepositoryException {
        this.setStringIfNotBlank(node, propertyName, directory.getString(tag));
    }

    private void setStringIfNotBlank(Node node, String propertyName, String value) throws RepositoryException {
        if (!StringUtil.isBlank((String)value)) {
            node.setProperty(propertyName, value);
        }
    }

    private void setDoubleIfTagPresent(Node node, String propertyName, Directory directory, int tag) throws RepositoryException {
        if (!directory.containsTag(tag)) {
            return;
        }
        node.setProperty(propertyName, directory.getRational(tag).doubleValue());
    }

    private boolean hasTags(Directory directory, int ... tags) {
        for (int tag : tags) {
            if (!directory.containsTag(tag)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processUsingDefaultMetadata(Node imageNode, Binary binaryValue) throws Exception {
        try (InputStream stream = binaryValue.getStream();){
            ImageMetadata metadata = new ImageMetadata();
            metadata.setInput(stream);
            metadata.setDetermineImageNumber(true);
            metadata.setCollectComments(true);
            if (!metadata.check()) {
                this.getLogger().debug("Unknown format detected using default metadata parser.", new Object[0]);
                boolean bl = false;
                return bl;
            }
            this.setImagePropertiesOnNode(imageNode, metadata);
            boolean bl = true;
            return bl;
        }
    }

    private Node getImageMetadataNode(Node outputNode) throws RepositoryException {
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("image:metadata");
            return outputNode;
        }
        return outputNode.addNode("image:metadata", "image:metadata");
    }

    private void setImagePropertiesOnNode(Node node, ImageMetadata metadata) throws Exception {
        node.setProperty("jcr:mimeType", metadata.getMimeType());
        node.setProperty("image:formatName", metadata.getFormatName());
        node.setProperty("image:width", (long)metadata.getWidth());
        node.setProperty("image:height", (long)metadata.getHeight());
        node.setProperty("image:bitsPerPixel", (long)metadata.getBitsPerPixel());
        node.setProperty("image:progressive", metadata.isProgressive());
        node.setProperty("image:numberOfImages", (long)metadata.getNumberOfImages());
        node.setProperty("image:physicalWidthDpi", (long)metadata.getPhysicalWidthDpi());
        node.setProperty("image:physicalHeightDpi", (long)metadata.getPhysicalHeightDpi());
        node.setProperty("image:physicalWidthInches", (double)metadata.getPhysicalWidthInch());
        node.setProperty("image:physicalHeightInches", (double)metadata.getPhysicalHeightInch());
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("images.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(ImageMetadata.MIME_TYPE_STRINGS);
        this.registerDefaultMimeTypes(TIFF_MIME_TYPES);
    }
}

