/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.classfile.metadata.Visibility;
import org.modeshape.sequencer.javafile.SourceFileRecorder;
import org.modeshape.sequencer.javafile.metadata.AbstractMetadata;
import org.modeshape.sequencer.javafile.metadata.AnnotationMetadata;
import org.modeshape.sequencer.javafile.metadata.EnumMetadata;
import org.modeshape.sequencer.javafile.metadata.FieldMetadata;
import org.modeshape.sequencer.javafile.metadata.JavaMetadata;
import org.modeshape.sequencer.javafile.metadata.MethodMetadata;
import org.modeshape.sequencer.javafile.metadata.TypeMetadata;

public class ClassSourceFileRecorder
implements SourceFileRecorder {
    @Override
    public void record(Sequencer.Context context, Node outputNode, JavaMetadata javaMetadata) throws RepositoryException {
        String packageName = javaMetadata.getPackageMetadata().getName();
        for (TypeMetadata typeMetadata : javaMetadata.getTypeMetadata()) {
            Node typeNode = this.getTypeNode(packageName, typeMetadata, outputNode);
            this.writeClassMetadata(context, typeNode, typeMetadata);
        }
    }

    private Node getTypeNode(String packageName, TypeMetadata typeMetadata, Node outputNode) throws RepositoryException {
        String actualType = typeMetadata.getType().equals((Object)TypeMetadata.Type.ENUM) ? "class:enum" : "class:class";
        String fullyQualifiedName = packageName + "." + typeMetadata.getName();
        for (String segment : fullyQualifiedName.split("\\.")) {
            outputNode = outputNode.addNode(segment);
        }
        outputNode.setPrimaryType(actualType);
        return outputNode;
    }

    private void writeClassMetadata(Sequencer.Context context, Node typeNode, TypeMetadata typeMetadata) throws RepositoryException {
        this.setTypeMetaInformation(context, typeNode, typeMetadata);
        ArrayList<MethodMetadata> methods = new ArrayList<MethodMetadata>();
        ArrayList<MethodMetadata> ctors = new ArrayList<MethodMetadata>();
        for (MethodMetadata method : typeMetadata.getMethods()) {
            if (method.getType() == MethodMetadata.Type.CONSTRUCTOR) {
                ctors.add(method);
                continue;
            }
            methods.add(method);
        }
        Node constructorsNode = typeNode.addNode("class:constructors", "class:constructors");
        this.writeMethods(constructorsNode, ctors);
        Node methodsNode = typeNode.addNode("class:methods", "class:methods");
        this.writeMethods(methodsNode, methods);
        Node fieldsNode = typeNode.addNode("class:fields", "class:fields");
        this.writeFieldsNode(fieldsNode, typeMetadata.getFields());
        this.writeAnnotationsNode(typeNode, typeMetadata.getAnnotations());
    }

    private void setTypeMetaInformation(Sequencer.Context context, Node typeNode, TypeMetadata typeMetadata) throws RepositoryException {
        typeNode.setProperty("class:name", typeMetadata.getName());
        typeNode.setProperty("class:sequencedDate", context.getTimestamp());
        String superTypeName = typeMetadata.getSuperTypeName();
        if (StringUtil.isBlank((String)superTypeName)) {
            superTypeName = Object.class.getCanonicalName();
        }
        typeNode.setProperty("class:superClassName", superTypeName);
        typeNode.setProperty("class:visibility", this.visibilityFor(typeMetadata).getDescription());
        typeNode.setProperty("class:abstract", typeMetadata.hasAbstractModifier());
        typeNode.setProperty("class:interface", typeMetadata.getType() == TypeMetadata.Type.INTERFACE);
        typeNode.setProperty("class:final", typeMetadata.hasFinalModifier());
        typeNode.setProperty("class:strictFp", typeMetadata.hasStrictFPModifier());
        typeNode.setProperty("class:interfaces", typeMetadata.getInterfaceNames().toArray(new String[0]));
        if (typeMetadata instanceof EnumMetadata) {
            typeNode.setProperty("class:enumValues", ((EnumMetadata)typeMetadata).getValues().toArray(new String[0]));
        }
    }

    private Visibility visibilityFor(AbstractMetadata typeMetadata) {
        if (typeMetadata.hasPublicVisibility()) {
            return Visibility.PUBLIC;
        }
        if (typeMetadata.hasProtectedVisibility()) {
            return Visibility.PROTECTED;
        }
        if (typeMetadata.hasPrivateVisibility()) {
            return Visibility.PRIVATE;
        }
        return Visibility.PACKAGE;
    }

    private void writeAnnotationsNode(Node rootNode, List<AnnotationMetadata> annotations) throws RepositoryException {
        if (annotations.isEmpty()) {
            return;
        }
        Node annotationsContainer = rootNode.addNode("class:annotations", "class:annotations");
        for (AnnotationMetadata annotationMetadata : annotations) {
            Node annotation = annotationsContainer.addNode("class:annotation", "class:annotation");
            annotation.setProperty("class:name", annotationMetadata.getName());
            for (Map.Entry<String, String> entry : annotationMetadata.getMemberValues().entrySet()) {
                String key = entry.getKey();
                if (key == null) {
                    key = "default";
                }
                Node annotationMember = annotation.addNode(key, "class:annotationMember");
                annotationMember.setProperty("class:name", key);
                annotationMember.setProperty("class:value", entry.getValue());
            }
        }
    }

    private void writeFieldsNode(Node fields, List<FieldMetadata> fieldsMetadata) throws RepositoryException {
        for (FieldMetadata fieldMetadata : fieldsMetadata) {
            Node field = fields.addNode(fieldMetadata.getName(), "class:field");
            field.setProperty("class:name", fieldMetadata.getName());
            field.setProperty("class:typeClassName", fieldMetadata.getType());
            field.setProperty("class:visibility", this.visibilityFor(fieldMetadata).getDescription());
            field.setProperty("class:static", fieldMetadata.hasStaticModifier());
            field.setProperty("class:final", fieldMetadata.hasFinalModifier());
            field.setProperty("class:transient", fieldMetadata.hasTransientModifier());
            field.setProperty("class:volatile", fieldMetadata.hasVolatileModifier());
            this.writeAnnotationsNode(field, fieldMetadata.getAnnotations());
        }
    }

    private void writeMethods(Node rootNode, List<MethodMetadata> methods) throws RepositoryException {
        for (MethodMetadata methodMetadata : methods) {
            Node method = rootNode.addNode(methodMetadata.getId(), "class:method");
            method.setProperty("class:name", methodMetadata.getName());
            method.setProperty("class:returnTypeClassName", methodMetadata.getReturnTypeName());
            method.setProperty("class:visibility", this.visibilityFor(methodMetadata).getDescription());
            method.setProperty("class:static", methodMetadata.hasStaticModifier());
            method.setProperty("class:final", methodMetadata.hasFinalModifier());
            method.setProperty("class:abstract", methodMetadata.hasAbstractModifier());
            method.setProperty("class:strictFp", methodMetadata.hasStrictFPModifier());
            method.setProperty("class:native", methodMetadata.hasNativeModifier());
            method.setProperty("class:synchronized", methodMetadata.hasSynchronizedModifier());
            method.setProperty("class:parameters", methodMetadata.getParameterTypes().toArray(new String[0]));
            this.writeAnnotationsNode(method, methodMetadata.getAnnotations());
        }
    }
}

