/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.javafile.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.modeshape.sequencer.javafile.AbstractJavaMetadata;
import org.modeshape.sequencer.javafile.CompilationUnitParser;
import org.modeshape.sequencer.javafile.JavaMetadataUtil;
import org.modeshape.sequencer.javafile.metadata.ImportMetadata;
import org.modeshape.sequencer.javafile.metadata.PackageMetadata;
import org.modeshape.sequencer.javafile.metadata.TypeMetadata;

public class JavaMetadata
extends AbstractJavaMetadata {
    private PackageMetadata packageMetadata;
    private List<ImportMetadata> imports;
    private List<TypeMetadata> types;

    private JavaMetadata() {
    }

    public static JavaMetadata instance(InputStream inputStream, long length, String encoding) throws IOException {
        JavaMetadata javaMetadata = new JavaMetadata();
        char[] source = JavaMetadataUtil.getJavaSourceFromTheInputStream(inputStream, length, encoding);
        CompilationUnit unit = (CompilationUnit)CompilationUnitParser.runJLS3Conversion(source, true);
        if (unit != null) {
            javaMetadata.packageMetadata = javaMetadata.createPackageMetadata(unit);
            javaMetadata.imports = javaMetadata.createImportMetadata(unit);
            javaMetadata.types = javaMetadata.createTypeMetadata(unit);
        }
        return javaMetadata;
    }

    public final PackageMetadata getPackageMetadata() {
        return this.packageMetadata;
    }

    public List<ImportMetadata> getImports() {
        return this.imports;
    }

    public List<TypeMetadata> getTypeMetadata() {
        return this.types;
    }
}

