/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class AudioStreamChunk
extends StreamChunk {
    public static final String[][] CODEC_DESCRIPTIONS = new String[][]{{"161", " (Windows Media Audio (ver 7,8,9))"}, {"162", " (Windows Media Audio 9 series (Professional))"}, {"163", "(Windows Media Audio 9 series (Lossless))"}, {"7A21", " (GSM-AMR (CBR))"}, {"7A22", " (GSM-AMR (VBR))"}};
    private long averageBytesPerSec;
    private int bitsPerSample;
    private long blockAlignment;
    private long channelCount;
    private byte[] codecData;
    private long compressionFormat;
    private GUID errorConcealment;
    private long samplingRate;

    public AudioStreamChunk(long pos, BigInteger chunkLen) {
        super(pos, chunkLen);
    }

    public long getAverageBytesPerSec() {
        return this.averageBytesPerSec;
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public long getBlockAlignment() {
        return this.blockAlignment;
    }

    public long getChannelCount() {
        return this.channelCount;
    }

    public byte[] getCodecData() {
        return this.codecData;
    }

    public String getCodecDescription() {
        StringBuffer result = new StringBuffer(Long.toHexString(this.getCompressionFormat()));
        String furtherDesc = " (Unknown)";
        for (int i = 0; i < CODEC_DESCRIPTIONS.length; ++i) {
            if (!CODEC_DESCRIPTIONS[i][0].equalsIgnoreCase(result.toString())) continue;
            furtherDesc = CODEC_DESCRIPTIONS[i][1];
            break;
        }
        if (result.length() % 2 != 0) {
            result.insert(0, "0x0");
        } else {
            result.insert(0, "0x");
        }
        result.append(furtherDesc);
        return result.toString();
    }

    public long getCompressionFormat() {
        return this.compressionFormat;
    }

    public GUID getErrorConcealment() {
        return this.errorConcealment;
    }

    public int getKbps() {
        return (int)this.getAverageBytesPerSec() * 8 / 1000;
    }

    public long getSamplingRate() {
        return this.samplingRate;
    }

    public boolean isErrorConcealed() {
        return this.getErrorConcealment().equals(GUID.GUID_AUDIO_ERROR_CONCEALEMENT_INTERLEAVED);
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer(super.prettyPrint().replaceAll(Utils.LINE_SEPARATOR, Utils.LINE_SEPARATOR + "   "));
        result.insert(0, Utils.LINE_SEPARATOR + "AudioStream");
        result.append("Audio info:" + Utils.LINE_SEPARATOR);
        result.append("      Bitrate : " + this.getKbps() + Utils.LINE_SEPARATOR);
        result.append("      Channels : " + this.getChannelCount() + " at " + this.getSamplingRate() + " Hz" + Utils.LINE_SEPARATOR);
        result.append("      Bits per Sample: " + this.getBitsPerSample() + Utils.LINE_SEPARATOR);
        result.append("      Formatcode: " + this.getCodecDescription() + Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setAverageBytesPerSec(long avgeBytesPerSec) {
        this.averageBytesPerSec = avgeBytesPerSec;
    }

    public void setBitsPerSample(int bps) {
        this.bitsPerSample = bps;
    }

    public void setBlockAlignment(long align) {
        this.blockAlignment = align;
    }

    public void setChannelCount(long channels) {
        this.channelCount = channels;
    }

    public void setCodecData(byte[] codecSpecificData) {
        this.codecData = codecSpecificData;
    }

    public void setCompressionFormat(long cFormatCode) {
        this.compressionFormat = cFormatCode;
    }

    public void setErrorConcealment(GUID errConc) {
        this.errorConcealment = errConc;
    }

    public void setSamplingRate(long sampRate) {
        this.samplingRate = sampRate;
    }
}

