/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;

public class ContentDescription
extends Chunk {
    private String author = null;
    private String copyRight = null;
    private String description = null;
    private String rating = null;
    private String title = null;

    public ContentDescription() {
        this(0L, BigInteger.valueOf(0L));
    }

    public ContentDescription(long pos, BigInteger chunkLen) {
        super(GUID.GUID_CONTENTDESCRIPTION, pos, chunkLen);
    }

    public String getAuthor() {
        if (this.author == null) {
            return "";
        }
        return this.author;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            int i;
            ByteArrayOutputStream tags = new ByteArrayOutputStream();
            String[] toWrite = new String[]{this.getTitle(), this.getAuthor(), this.getCopyRight(), this.getComment(), this.getRating()};
            byte[][] stringRepresentations = new byte[toWrite.length][];
            for (i = 0; i < toWrite.length; ++i) {
                stringRepresentations[i] = toWrite[i].getBytes("UTF-16LE");
            }
            for (i = 0; i < stringRepresentations.length; ++i) {
                tags.write(Utils.getBytes(stringRepresentations[i].length + 2, 2));
            }
            for (i = 0; i < toWrite.length; ++i) {
                tags.write(stringRepresentations[i]);
                tags.write(Utils.getBytes(0L, 2));
            }
            byte[] tagContent = tags.toByteArray();
            result.write(GUID.GUID_CONTENTDESCRIPTION.getBytes());
            result.write(Utils.getBytes(tagContent.length + 24, 8));
            result.write(tagContent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toByteArray();
    }

    public String getComment() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public String getCopyRight() {
        if (this.copyRight == null) {
            return "";
        }
        return this.copyRight;
    }

    public String getRating() {
        if (this.rating == null) {
            return "";
        }
        return this.rating;
    }

    public String getTitle() {
        if (this.title == null) {
            return "";
        }
        return this.title;
    }

    public String prettyPrint() {
        StringBuffer result = new StringBuffer(super.prettyPrint());
        result.insert(0, Utils.LINE_SEPARATOR + "Content Description:" + Utils.LINE_SEPARATOR);
        result.append("   Title      : " + this.getTitle() + Utils.LINE_SEPARATOR);
        result.append("   Author     : " + this.getAuthor() + Utils.LINE_SEPARATOR);
        result.append("   Copyright  : " + this.getCopyRight() + Utils.LINE_SEPARATOR);
        result.append("   Description: " + this.getComment() + Utils.LINE_SEPARATOR);
        result.append("   Rating     :" + this.getRating() + Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setAuthor(String fileAuthor) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(fileAuthor);
        this.author = fileAuthor;
    }

    public void setComment(String tagComment) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(tagComment);
        this.description = tagComment;
    }

    public void setCopyRight(String cpright) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(cpright);
        this.copyRight = cpright;
    }

    public void setRating(String ratingText) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(ratingText);
        this.rating = ratingText;
    }

    public void setTitle(String songTitle) throws IllegalArgumentException {
        Utils.checkStringLengthNullSafe(songTitle);
        this.title = songTitle;
    }
}

