/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTag
implements Tag {
    protected int commonNumber = 0;
    protected Map<String, List<TagField>> fields = new LinkedHashMap<String, List<TagField>>();

    @Override
    public void add(TagField field) {
        if (field == null) {
            return;
        }
        List<TagField> list = this.fields.get(field.getId());
        if (list == null) {
            list = new ArrayList<TagField>();
            list.add(field);
            this.fields.put(field.getId(), list);
            if (field.isCommon()) {
                ++this.commonNumber;
            }
        } else {
            list.add(field);
        }
    }

    @Override
    public void addAlbum(String s) {
        this.add(this.createAlbumField(s));
    }

    @Override
    public void addArtist(String s) {
        this.add(this.createArtistField(s));
    }

    @Override
    public void addComment(String s) {
        this.add(this.createCommentField(s));
    }

    @Override
    public void addGenre(String s) {
        this.add(this.createGenreField(s));
    }

    @Override
    public void addTitle(String s) {
        this.add(this.createTitleField(s));
    }

    @Override
    public void addTrack(String s) throws FieldDataInvalidException {
        this.add(this.createTrackField(s));
    }

    @Override
    public void addYear(String s) {
        this.add(this.createYearField(s));
    }

    @Override
    public List<TagField> get(String id) {
        List<TagField> list = this.fields.get(id);
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    @Override
    public List<TagField> get(TagFieldKey id) throws KeyNotFoundException {
        List<TagField> list = this.fields.get(id.name());
        if (list == null) {
            return new ArrayList<TagField>();
        }
        return list;
    }

    @Override
    public String getFirst(String id) {
        List<TagField> l = this.get(id);
        return l.size() != 0 ? ((Object)l.get(0)).toString() : "";
    }

    @Override
    public TagField getFirstField(String id) {
        List<TagField> l = this.get(id);
        return l.size() != 0 ? l.get(0) : null;
    }

    public List getAlbum() {
        return this.get(this.getAlbumId());
    }

    protected abstract String getAlbumId();

    public List getArtist() {
        return this.get(this.getArtistId());
    }

    protected abstract String getArtistId();

    public List getComment() {
        return this.get(this.getCommentId());
    }

    protected abstract String getCommentId();

    @Override
    public Iterator getFields() {
        final Iterator<Map.Entry<String, List<TagField>>> it = this.fields.entrySet().iterator();
        return new Iterator(){
            private Iterator fieldsIt;

            private void changeIt() {
                if (!it.hasNext()) {
                    return;
                }
                Map.Entry e = (Map.Entry)it.next();
                List l = (List)e.getValue();
                this.fieldsIt = l.iterator();
            }

            public boolean hasNext() {
                if (this.fieldsIt == null) {
                    this.changeIt();
                }
                return it.hasNext() || this.fieldsIt != null && this.fieldsIt.hasNext();
            }

            public Object next() {
                if (!this.fieldsIt.hasNext()) {
                    this.changeIt();
                }
                return this.fieldsIt.next();
            }

            public void remove() {
                this.fieldsIt.remove();
            }
        };
    }

    @Override
    public int getFieldCount() {
        Iterator it = this.getFields();
        int count = 0;
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    @Override
    public String getFirstAlbum() {
        List l = this.getAlbum();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstArtist() {
        List l = this.getArtist();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstComment() {
        List l = this.getComment();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstGenre() {
        List l = this.getGenre();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstTitle() {
        List l = this.getTitle();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstTrack() {
        List l = this.getTrack();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    @Override
    public String getFirstYear() {
        List l = this.getYear();
        return l.size() != 0 ? ((TagTextField)l.get(0)).getContent() : "";
    }

    public List getGenre() {
        return this.get(this.getGenreId());
    }

    protected abstract String getGenreId();

    public List getTitle() {
        return this.get(this.getTitleId());
    }

    protected abstract String getTitleId();

    public List getTrack() {
        return this.get(this.getTrackId());
    }

    protected abstract String getTrackId();

    public List getYear() {
        return this.get(this.getYearId());
    }

    protected abstract String getYearId();

    @Override
    public boolean hasCommonFields() {
        return this.commonNumber != 0;
    }

    @Override
    public boolean hasField(String id) {
        return this.get(id).size() != 0;
    }

    protected abstract boolean isAllowedEncoding(String var1);

    @Override
    public boolean isEmpty() {
        return this.fields.size() == 0;
    }

    @Override
    public void set(TagField field) {
        if (field == null) {
            return;
        }
        List<TagField> list = this.fields.get(field.getId());
        if (list != null) {
            list.set(0, field);
            return;
        }
        list = new ArrayList<TagField>();
        list.add(field);
        this.fields.put(field.getId(), list);
        if (field.isCommon()) {
            ++this.commonNumber;
        }
    }

    @Override
    public void setAlbum(String s) {
        this.set(this.createAlbumField(s));
    }

    @Override
    public void setArtist(String s) {
        this.set(this.createArtistField(s));
    }

    @Override
    public void setComment(String s) {
        this.set(this.createCommentField(s));
    }

    @Override
    public boolean setEncoding(String enc) {
        if (!this.isAllowedEncoding(enc)) {
            return false;
        }
        Iterator it = this.getFields();
        while (it.hasNext()) {
            TagField field = (TagField)it.next();
            if (!(field instanceof TagTextField)) continue;
            ((TagTextField)field).setEncoding(enc);
        }
        return true;
    }

    @Override
    public void setGenre(String s) {
        this.set(this.createGenreField(s));
    }

    @Override
    public void setTitle(String s) {
        this.set(this.createTitleField(s));
    }

    @Override
    public void setTrack(String s) throws FieldDataInvalidException {
        this.set(this.createTrackField(s));
    }

    @Override
    public void setYear(String s) {
        this.set(this.createYearField(s));
    }

    @Override
    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Tag content:\n");
        Iterator it = this.getFields();
        while (it.hasNext()) {
            TagField field = (TagField)it.next();
            out.append("\t");
            out.append(field.getId());
            out.append(":");
            out.append(((Object)field).toString());
            out.append("\n");
        }
        return out.toString().substring(0, out.length() - 1);
    }

    @Override
    public TagField createTagField(TagFieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        return null;
    }

    @Override
    public String getFirst(TagFieldKey genericKey) throws KeyNotFoundException {
        return null;
    }

    @Override
    public void deleteTagField(TagFieldKey tagFieldKey) throws KeyNotFoundException {
    }

    protected void deleteField(String key) {
        List<TagField> removed = this.fields.remove(key);
    }

    public abstract TagField createAlbumField(String var1);

    public abstract TagField createArtistField(String var1);

    public abstract TagField createCommentField(String var1);

    public abstract TagField createGenreField(String var1);

    public abstract TagField createTitleField(String var1);

    public abstract TagField createTrackField(String var1) throws FieldDataInvalidException;

    public abstract TagField createYearField(String var1);
}

