/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.LameFrame;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;

public class XingFrame {
    private static final int MPEG_VERSION_1_MODE_MONO_OFFSET = 21;
    private static final int MPEG_VERSION_1_MODE_STEREO_OFFSET = 36;
    private static final int MPEG_VERSION_2_MODE_MONO_OFFSET = 13;
    private static final int MPEG_VERSION_2_MODE_STEREO_OFFSET = 21;
    private static final int XING_HEADER_BUFFER_SIZE = 120;
    private static final int XING_IDENTIFIER_BUFFER_SIZE = 4;
    private static final int XING_FLAG_BUFFER_SIZE = 4;
    private static final int XING_FRAMECOUNT_BUFFER_SIZE = 4;
    private static final int XING_AUDIOSIZE_BUFFER_SIZE = 4;
    public static final int MAX_BUFFER_SIZE_NEEDED_TO_READ_XING = 192;
    private static final int BYTE_1 = 0;
    private static final int BYTE_2 = 1;
    private static final int BYTE_3 = 2;
    private static final int BYTE_4 = 3;
    private static final byte[] XING_VBR_ID = new byte[]{88, 105, 110, 103};
    private static final byte[] XING_CBR_ID = new byte[]{73, 110, 102, 111};
    private static ByteBuffer header;
    private static XingFrame xingFrame;
    private boolean vbr = false;
    private boolean isFrameCountEnabled = false;
    private int frameCount = -1;
    private boolean isAudioSizeEnabled = false;
    private int audioSize = -1;
    private LameFrame lameFrame;

    private XingFrame() {
        header.rewind();
        this.setVbr();
        byte[] flagBuffer = new byte[4];
        header.get(flagBuffer);
        if ((flagBuffer[3] & 1) != 0) {
            this.setFrameCount();
        }
        if ((flagBuffer[3] & 2) != 0) {
            this.setAudioSize();
        }
        if (header.limit() >= 156) {
            header.position(120);
            this.lameFrame = LameFrame.parseLameFrame(header);
        }
    }

    public LameFrame getLameFrame() {
        return this.lameFrame;
    }

    private void setVbr() {
        byte[] identifier = new byte[4];
        header.get(identifier);
        if (Arrays.equals(identifier, XING_VBR_ID)) {
            MP3File.logger.finest("Is Vbr");
            this.vbr = true;
        }
    }

    private void setFrameCount() {
        byte[] frameCountBuffer = new byte[4];
        header.get(frameCountBuffer);
        this.isFrameCountEnabled = true;
        this.frameCount = frameCountBuffer[0] << 24 & 0xFF000000 | frameCountBuffer[1] << 16 & 0xFF0000 | frameCountBuffer[2] << 8 & 0xFF00 | frameCountBuffer[3] & 0xFF;
    }

    public final boolean isFrameCountEnabled() {
        return this.isFrameCountEnabled;
    }

    public final int getFrameCount() {
        return this.frameCount;
    }

    private void setAudioSize() {
        byte[] frameSizeBuffer = new byte[4];
        header.get(frameSizeBuffer);
        this.isAudioSizeEnabled = true;
        this.audioSize = frameSizeBuffer[0] << 24 & 0xFF000000 | frameSizeBuffer[1] << 16 & 0xFF0000 | frameSizeBuffer[2] << 8 & 0xFF00 | frameSizeBuffer[3] & 0xFF;
    }

    public final boolean isAudioSizeEnabled() {
        return this.isAudioSizeEnabled;
    }

    public final int getAudioSize() {
        return this.audioSize;
    }

    public static XingFrame parseXingFrame() throws InvalidAudioFrameException {
        xingFrame = new XingFrame();
        return xingFrame;
    }

    public static boolean isXingFrame(ByteBuffer bb, MPEGFrameHeader mpegFrameHeader) {
        int startPosition = bb.position();
        if (mpegFrameHeader.getVersion() == 3) {
            if (mpegFrameHeader.getChannelMode() == 3) {
                bb.position(startPosition + 21);
            } else {
                bb.position(startPosition + 36);
            }
        } else if (mpegFrameHeader.getChannelMode() == 3) {
            bb.position(startPosition + 13);
        } else {
            bb.position(startPosition + 21);
        }
        header = bb.slice();
        bb.position(startPosition);
        byte[] identifier = new byte[4];
        header.get(identifier);
        if (!Arrays.equals(identifier, XING_VBR_ID) && !Arrays.equals(identifier, XING_CBR_ID)) {
            return false;
        }
        MP3File.logger.finest("Found Xing Frame");
        return true;
    }

    public final boolean isVbr() {
        return this.vbr;
    }

    public String toString() {
        return "xingheader vbr:" + this.vbr + " frameCountEnabled:" + this.isFrameCountEnabled + " frameCount:" + this.frameCount + " audioSizeEnabled:" + this.isAudioSizeEnabled + " audioFileSize:" + this.audioSize;
    }

    static {
        xingFrame = null;
    }
}

