/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.ArrayList;
import java.util.ListIterator;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Tags;

public class GroupRepeated
extends AbstractDataType {
    private ArrayList objectList;
    private ArrayList propertyList;

    public GroupRepeated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
        this.propertyList = new ArrayList();
        this.objectList = new ArrayList();
    }

    public GroupRepeated(GroupRepeated copy) {
        super(copy);
        AbstractDataType newObject;
        int i;
        for (i = 0; i < copy.objectList.size(); ++i) {
            newObject = (AbstractDataType)ID3Tags.copyObject(copy.objectList.get(i));
            this.objectList.add(newObject);
        }
        for (i = 0; i < copy.propertyList.size(); ++i) {
            newObject = (AbstractDataType)ID3Tags.copyObject(copy.propertyList.get(i));
            this.propertyList.add(newObject);
        }
    }

    public ArrayList getObjectList() {
        return this.objectList;
    }

    public ArrayList getPropertyList() {
        return this.propertyList;
    }

    public int getSize() {
        int size = 0;
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractDataType object = (AbstractDataType)iterator.next();
            size += object.getSize();
        }
        return size;
    }

    public void addObject(AbstractDataType obj) {
        this.objectList.add(obj);
    }

    public void addProperty(AbstractDataType obj) {
        this.propertyList.add(obj);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupRepeated)) {
            return false;
        }
        GroupRepeated object = (GroupRepeated)obj;
        if (!this.objectList.equals(object.objectList)) {
            return false;
        }
        if (!this.propertyList.equals(object.propertyList)) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0 || offset >= arr.length) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        if (!this.propertyList.isEmpty()) {
            while (offset < arr.length) {
                ListIterator iterator = this.propertyList.listIterator();
                while (iterator.hasNext()) {
                    Class<?> className = iterator.next().getClass();
                    try {
                        AbstractDataType object = (AbstractDataType)className.newInstance();
                        this.objectList.add(object);
                        object.readByteArray(arr, offset);
                        offset += object.getSize();
                    }
                    catch (IllegalAccessException ex) {
                        logger.severe(ex.getMessage());
                    }
                    catch (InstantiationException ex) {
                        logger.severe(ex.getMessage());
                    }
                }
            }
        }
    }

    public String toString() {
        String str = "";
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractDataType object = (AbstractDataType)iterator.next();
            str = str + object.toString() + "\n";
        }
        return str;
    }

    public byte[] writeByteArray() {
        byte[] totalArray = new byte[this.getSize()];
        ListIterator iterator = this.objectList.listIterator();
        while (iterator.hasNext()) {
            AbstractDataType object = (AbstractDataType)iterator.next();
            byte[] objectArray = object.writeByteArray();
            System.arraycopy(objectArray, 0, totalArray, 0, totalArray.length);
        }
        return totalArray;
    }
}

