/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class TextEncodedStringNullTerminated
extends AbstractString {
    public TextEncodedStringNullTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public TextEncodedStringNullTerminated(String identifier, AbstractTagFrameBody frameBody, String value) {
        super(identifier, frameBody, value);
    }

    public TextEncodedStringNullTerminated(TextEncodedStringNullTerminated object) {
        super(object);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextEncodedStringNullTerminated)) {
            return false;
        }
        return super.equals(obj);
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        int bufferSize = 0;
        logger.finer("Reading from array starting from offset:" + offset);
        int size = 0;
        String charSetName = this.getTextEncodingCharSet();
        CharsetDecoder decoder = Charset.forName(charSetName).newDecoder();
        ByteBuffer buffer = ByteBuffer.wrap(arr, offset, arr.length - offset);
        int endPosition = 0;
        boolean nullIsOneByte = charSetName.equals("ISO-8859-1") || charSetName.equals("UTF-8");
        boolean isNullTerminatorFound = false;
        while (buffer.hasRemaining()) {
            byte nextByte = buffer.get();
            if (nextByte == 0) {
                if (nullIsOneByte) {
                    buffer.mark();
                    buffer.reset();
                    endPosition = buffer.position() - 1;
                    logger.finest("Null terminator found starting at:" + endPosition);
                    isNullTerminatorFound = true;
                    break;
                }
                if (buffer.hasRemaining()) {
                    nextByte = buffer.get();
                    if (nextByte != 0) continue;
                    buffer.mark();
                    buffer.reset();
                    endPosition = buffer.position() - 2;
                    logger.finest("UTF16:Null terminator found starting  at:" + endPosition);
                    isNullTerminatorFound = true;
                    break;
                }
                buffer.mark();
                buffer.reset();
                endPosition = buffer.position() - 1;
                logger.warning("UTF16:Should be two null terminator marks but only found one starting at:" + endPosition);
                isNullTerminatorFound = true;
                break;
            }
            if (nullIsOneByte || !buffer.hasRemaining()) continue;
            buffer.get();
        }
        if (!isNullTerminatorFound) {
            throw new InvalidDataTypeException("Unable to find null terminated string");
        }
        logger.finest("End Position is:" + endPosition + "Offset:" + offset);
        size = endPosition - offset;
        ++size;
        if (!nullIsOneByte) {
            ++size;
        }
        this.setSize(size);
        bufferSize = endPosition - offset;
        logger.finest("Text size is:" + bufferSize);
        if (bufferSize == 0) {
            this.value = "";
        } else {
            ByteBuffer inBuffer = ByteBuffer.wrap(arr, offset, bufferSize).slice();
            CharBuffer outBuffer = CharBuffer.allocate(bufferSize);
            decoder.reset();
            CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
            if (coderResult.isError()) {
                logger.warning("Problem decoding text encoded null terminated string:" + coderResult.toString());
            }
            decoder.flush(outBuffer);
            outBuffer.flip();
            this.value = outBuffer.toString();
        }
        logger.info("Read NullTerminatedString:" + this.value + " size inc terminator:" + size);
    }

    public byte[] writeByteArray() {
        logger.info("Writing NullTerminatedString." + this.value);
        byte[] data = null;
        try {
            String charSetName = this.getTextEncodingCharSet();
            CharsetEncoder encoder = Charset.forName(charSetName).newEncoder();
            ByteBuffer bb = encoder.encode(CharBuffer.wrap((String)this.value + '\u0000'));
            data = new byte[bb.limit()];
            bb.get(data, 0, bb.limit());
        }
        catch (CharacterCodingException ce) {
            logger.severe(ce.getMessage());
            throw new RuntimeException(ce);
        }
        this.setSize(data.length);
        return data;
    }

    protected String getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        String charSetName = TextEncoding.getInstanceOf().getValueForId(textEncoding);
        logger.finest("text encoding:" + textEncoding + " charset:" + charSetName);
        return charSetName;
    }
}

