/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.logging.Level;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3Unsynchronization;
import org.jaudiotagger.tag.id3.ID3v23FieldKey;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Tag;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDAT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTDRC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIME;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTYER;

public class ID3v23Tag
extends AbstractID3v2Tag {
    protected static final String TYPE_CRCDATA = "crcdata";
    protected static final String TYPE_EXPERIMENTAL = "experimental";
    protected static final String TYPE_EXTENDED = "extended";
    protected static final String TYPE_PADDINGSIZE = "paddingsize";
    protected static final String TYPE_UNSYNCHRONISATION = "unsyncronisation";
    protected static int TAG_EXT_HEADER_LENGTH = 10;
    protected static int TAG_EXT_HEADER_CRC_LENGTH = 4;
    protected static int FIELD_TAG_EXT_SIZE_LENGTH = 4;
    protected static int TAG_EXT_HEADER_DATA_LENGTH = TAG_EXT_HEADER_LENGTH - FIELD_TAG_EXT_SIZE_LENGTH;
    public static final int MASK_V23_UNSYNCHRONIZATION = 128;
    public static final int MASK_V23_EXTENDED_HEADER = 64;
    public static final int MASK_V23_EXPERIMENTAL = 32;
    public static final int MASK_V23_CRC_DATA_PRESENT = 128;
    public static final int MASK_V23_EMBEDDED_INFO_FLAG = 2;
    protected boolean crcDataFlag = false;
    protected boolean experimental = false;
    protected boolean extended = false;
    protected int crcData = 0;
    protected int paddingSize = 0;
    protected boolean unsynchronization = false;
    protected boolean compression = false;
    public static final byte RELEASE = 2;
    public static final byte MAJOR_VERSION = 3;
    public static final byte REVISION = 0;

    public byte getRelease() {
        return 2;
    }

    public byte getMajorVersion() {
        return 3;
    }

    public byte getRevision() {
        return 0;
    }

    public ID3v23Tag() {
        this.frameMap = new LinkedHashMap();
    }

    protected void copyPrimitives(AbstractID3v2Tag copyObj) {
        logger.info("Copying primitives");
        super.copyPrimitives(copyObj);
        if (copyObj instanceof ID3v23Tag) {
            ID3v23Tag copyObject = (ID3v23Tag)copyObj;
            this.crcDataFlag = copyObject.crcDataFlag;
            this.experimental = copyObject.experimental;
            this.extended = copyObject.extended;
            this.crcData = copyObject.crcData;
            this.paddingSize = copyObject.paddingSize;
        }
    }

    protected void copyFrames(AbstractID3v2Tag copyObject) {
        logger.info("Copying Frames,there are:" + copyObject.frameMap.keySet().size() + " different types");
        this.frameMap = new LinkedHashMap();
        Iterator iterator = copyObject.frameMap.keySet().iterator();
        AbstractID3v2Frame newFrame = null;
        while (iterator.hasNext()) {
            AbstractID3v2Frame frame;
            String id = (String)iterator.next();
            Object o = copyObject.frameMap.get(id);
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                logger.info("Frame is:" + frame.getIdentifier());
                if (frame.getIdentifier().equals("TDRC") && frame.getBody() instanceof FrameBodyTDRC) {
                    this.translateFrame(frame);
                    continue;
                }
                try {
                    newFrame = new ID3v23Frame(frame);
                    logger.info("Adding Frame:" + newFrame.getIdentifier());
                    this.frameMap.put(newFrame.getIdentifier(), newFrame);
                }
                catch (InvalidFrameException ife) {
                    logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier());
                }
                continue;
            }
            if (!(o instanceof ArrayList)) continue;
            ArrayList<AbstractID3v2Frame> multiFrame = new ArrayList<AbstractID3v2Frame>();
            ListIterator li = ((ArrayList)o).listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                logger.info("Frame is MultiFrame:" + frame.getIdentifier());
                try {
                    newFrame = new ID3v23Frame(frame);
                    multiFrame.add(newFrame);
                }
                catch (InvalidFrameException ife) {
                    logger.log(Level.SEVERE, "Unable to convert frame:" + frame.getIdentifier(), ife);
                }
            }
            if (newFrame == null) continue;
            logger.info("Adding MultiFrame:" + newFrame.getIdentifier());
            this.frameMap.put(newFrame.getIdentifier(), multiFrame);
        }
    }

    protected void translateFrame(AbstractID3v2Frame frame) {
        ID3v23Frame newFrame;
        FrameBodyTDRC tmpBody = (FrameBodyTDRC)frame.getBody();
        if (!tmpBody.getYear().equals("")) {
            newFrame = new ID3v23Frame("TYER");
            ((FrameBodyTYER)newFrame.getBody()).setText(tmpBody.getYear());
            logger.info("Adding Frame:" + newFrame.getIdentifier());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
        if (!tmpBody.getDate().equals("")) {
            newFrame = new ID3v23Frame("TDAT");
            ((FrameBodyTDAT)newFrame.getBody()).setText(tmpBody.getDate());
            logger.info("Adding Frame:" + newFrame.getIdentifier());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
        if (!tmpBody.getTime().equals("")) {
            newFrame = new ID3v23Frame("TIME");
            ((FrameBodyTIME)newFrame.getBody()).setText(tmpBody.getTime());
            logger.info("Adding Frame:" + newFrame.getIdentifier());
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
    }

    public ID3v23Tag(ID3v23Tag copyObject) {
        super(copyObject);
        logger.info("Creating tag from another tag of same type");
        this.copyPrimitives(copyObject);
        this.copyFrames(copyObject);
    }

    public ID3v23Tag(AbstractTag mp3tag) {
        logger.info("Creating tag from a tag of a different version");
        this.frameMap = new LinkedHashMap();
        if (mp3tag != null) {
            if (!(mp3tag instanceof ID3v24Tag) && mp3tag instanceof ID3v23Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v24Tag convertedTag = mp3tag instanceof ID3v24Tag ? (ID3v24Tag)mp3tag : new ID3v24Tag(mp3tag);
            this.copyPrimitives(convertedTag);
            this.copyFrames(convertedTag);
            logger.info("Created tag from a tag of a different version");
        }
    }

    public ID3v23Tag(ByteBuffer buffer, String loggingFilename) throws TagException {
        this.setLoggingFilename(loggingFilename);
        this.read(buffer);
    }

    public ID3v23Tag(ByteBuffer buffer) throws TagException {
        this(buffer, "");
    }

    public String getIdentifier() {
        return "ID3v2.30";
    }

    public int getSize() {
        int size = 10;
        if (this.extended) {
            size += TAG_EXT_HEADER_LENGTH;
            if (this.crcDataFlag) {
                size += TAG_EXT_HEADER_CRC_LENGTH;
            }
        }
        return size += super.getSize();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v23Tag)) {
            return false;
        }
        ID3v23Tag object = (ID3v23Tag)obj;
        if (this.crcData != object.crcData) {
            return false;
        }
        if (this.crcDataFlag != object.crcDataFlag) {
            return false;
        }
        if (this.experimental != object.experimental) {
            return false;
        }
        if (this.extended != object.extended) {
            return false;
        }
        if (this.paddingSize != object.paddingSize) {
            return false;
        }
        return super.equals(obj);
    }

    public void read(ByteBuffer buffer) throws TagException {
        if (!this.seek(buffer)) {
            throw new TagNotFoundException(this.getIdentifier() + " tag not found");
        }
        logger.info(this.getLoggingFilename() + ":" + "Reading tag");
        byte flags = buffer.get();
        this.unsynchronization = (flags & 0x80) != 0;
        this.extended = (flags & 0x40) != 0;
        boolean bl = this.experimental = (flags & 0x20) != 0;
        if (this.isUnsynchronization()) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v23 Tag is unsynchronized");
        }
        if (this.extended) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v23 Tag is extended");
        }
        if (this.experimental) {
            logger.warning(this.getLoggingFilename() + ":" + "ID3v23 Tag is experimental");
        }
        int size = ID3SyncSafeInteger.bufferToValue(buffer);
        logger.info(this.getLoggingFilename() + ":Tag size is:" + size + " according to header (does not include header size, add 10)");
        if (this.extended) {
            int extendedHeaderSize = buffer.getInt();
            if (extendedHeaderSize == TAG_EXT_HEADER_DATA_LENGTH) {
                byte extFlag = buffer.get();
                boolean bl2 = this.crcDataFlag = (extFlag & 0x80) != 0;
                if (this.crcDataFlag) {
                    throw new InvalidTagException(this.getLoggingFilename() + ":CRC Data flag not set correctly.");
                }
                buffer.get();
                size -= buffer.getInt() + TAG_EXT_HEADER_LENGTH;
            } else if (extendedHeaderSize == TAG_EXT_HEADER_DATA_LENGTH + TAG_EXT_HEADER_CRC_LENGTH) {
                byte extFlag = buffer.get();
                boolean bl3 = this.crcDataFlag = (extFlag & 0x80) != 0;
                if (!this.crcDataFlag) {
                    throw new InvalidTagException(this.getLoggingFilename() + ":CRC Data flag not set correctly.");
                }
                buffer.get();
                size -= buffer.getInt() + TAG_EXT_HEADER_LENGTH + TAG_EXT_HEADER_CRC_LENGTH;
                this.crcData = buffer.getInt();
            } else {
                throw new InvalidTagException("Invalid Extended Header Size.");
            }
            logger.info(this.getLoggingFilename() + ":has Extended Header so adjusted Tag size is:" + size);
        }
        ByteBuffer bufferWithoutHeader = buffer.slice();
        if (this.isUnsynchronization()) {
            bufferWithoutHeader = ID3Unsynchronization.synchronize(bufferWithoutHeader);
        }
        this.readFrames(bufferWithoutHeader, size);
        logger.info(this.getLoggingFilename() + ":Loaded Frames,there are:" + this.frameMap.keySet().size());
    }

    protected void readFrames(ByteBuffer byteBuffer, int size) {
        this.frameMap = new LinkedHashMap();
        this.fileReadSize = size;
        logger.finest(this.getLoggingFilename() + ":Start of frame body at:" + byteBuffer.position() + ",frames data size is:" + size);
        while (byteBuffer.position() < size) {
            try {
                logger.finest(this.getLoggingFilename() + ":Looking for next frame at:" + byteBuffer.position());
                ID3v23Frame next = new ID3v23Frame(byteBuffer, this.getLoggingFilename());
                String id = next.getIdentifier();
                this.loadFrameIntoMap(id, next);
            }
            catch (EmptyFrameException ex) {
                logger.warning(this.getLoggingFilename() + ":Empty Frame:" + ex.getMessage());
                this.emptyFrameBytes += 10;
            }
            catch (InvalidFrameIdentifierException ifie) {
                logger.info(this.getLoggingFilename() + ":Invalid Frame Identifier:" + ifie.getMessage());
                ++this.invalidFrameBytes;
                break;
            }
            catch (InvalidFrameException ife) {
                logger.warning(this.getLoggingFilename() + ":Invalid Frame:" + ife.getMessage());
                ++this.invalidFrameBytes;
                break;
            }
        }
    }

    private ByteBuffer writeHeaderToBuffer(int padding, int size) throws IOException {
        this.extended = false;
        this.experimental = false;
        this.crcDataFlag = false;
        ByteBuffer headerBuffer = ByteBuffer.allocate(10 + TAG_EXT_HEADER_LENGTH + TAG_EXT_HEADER_CRC_LENGTH);
        headerBuffer.put(TAG_ID);
        headerBuffer.put(this.getMajorVersion());
        headerBuffer.put(this.getRevision());
        byte flagsByte = 0;
        if (this.isUnsynchronization()) {
            flagsByte = (byte)(flagsByte | 0x80);
        }
        if (this.extended) {
            flagsByte = (byte)(flagsByte | 0x40);
        }
        if (this.experimental) {
            flagsByte = (byte)(flagsByte | 0x20);
        }
        headerBuffer.put(flagsByte);
        int additionalHeaderSize = 0;
        if (this.extended) {
            additionalHeaderSize += TAG_EXT_HEADER_LENGTH;
            if (this.crcDataFlag) {
                additionalHeaderSize += TAG_EXT_HEADER_CRC_LENGTH;
            }
        }
        headerBuffer.put(ID3SyncSafeInteger.valueToBuffer(padding + size + additionalHeaderSize));
        if (this.extended) {
            byte extFlagsByte1 = 0;
            byte extFlagsByte2 = 0;
            if (this.crcDataFlag) {
                headerBuffer.putInt(TAG_EXT_HEADER_DATA_LENGTH + TAG_EXT_HEADER_CRC_LENGTH);
                extFlagsByte1 = (byte)(extFlagsByte1 | 0x80);
                headerBuffer.put(extFlagsByte1);
                headerBuffer.put(extFlagsByte2);
                headerBuffer.putInt(this.paddingSize);
                headerBuffer.putInt(this.crcData);
            } else {
                headerBuffer.putInt(TAG_EXT_HEADER_DATA_LENGTH);
                headerBuffer.put(extFlagsByte1);
                headerBuffer.put(extFlagsByte2);
                headerBuffer.putInt(padding);
            }
        }
        headerBuffer.flip();
        return headerBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(File file, long audioStartLocation) throws IOException {
        logger.info(this.getLoggingFilename() + ":Writing tag to file");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + bodyByteBuffer.length);
        this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() ? ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer) : false;
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        int sizeIncPadding = this.calculateTagSize(bodyByteBuffer.length + 10, (int)audioStartLocation);
        int padding = sizeIncPadding - (bodyByteBuffer.length + 10);
        logger.info(this.getLoggingFilename() + ":Current audiostart:" + audioStartLocation);
        logger.info(this.getLoggingFilename() + ":Size including padding:" + sizeIncPadding);
        logger.info(this.getLoggingFilename() + ":Padding:" + padding);
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(padding, bodyByteBuffer.length);
        if ((long)sizeIncPadding > audioStartLocation) {
            logger.info(this.getLoggingFilename() + ":Adjusting Padding");
            this.adjustPadding(file, sizeIncPadding, audioStartLocation);
        }
        FileChannel fc = null;
        try {
            fc = new RandomAccessFile(file, "rw").getChannel();
            fc.write(headerBuffer);
            fc.write(ByteBuffer.wrap(bodyByteBuffer));
            fc.write(ByteBuffer.wrap(new byte[padding]));
            Object var10_8 = null;
            if (fc == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (fc == null) throw throwable;
            fc.close();
            throw throwable;
        }
        fc.close();
    }

    public void write(WritableByteChannel channel) throws IOException {
        logger.info(this.getLoggingFilename() + ":Writing tag to channel");
        byte[] bodyByteBuffer = this.writeFramesToBuffer().toByteArray();
        logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizebeforeunsynchronisation:" + bodyByteBuffer.length);
        this.unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() ? ID3Unsynchronization.requiresUnsynchronization(bodyByteBuffer) : false;
        if (this.isUnsynchronization()) {
            bodyByteBuffer = ID3Unsynchronization.unsynchronize(bodyByteBuffer);
            logger.info(this.getLoggingFilename() + ":bodybytebuffer:sizeafterunsynchronisation:" + bodyByteBuffer.length);
        }
        ByteBuffer headerBuffer = this.writeHeaderToBuffer(0, bodyByteBuffer.length);
        channel.write(headerBuffer);
        channel.write(ByteBuffer.wrap(bodyByteBuffer));
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        super.createStructureHeader();
        MP3File.getStructureFormatter().openHeadingElement("header", "");
        MP3File.getStructureFormatter().addElement(TYPE_UNSYNCHRONISATION, this.isUnsynchronization());
        MP3File.getStructureFormatter().addElement(TYPE_EXTENDED, this.extended);
        MP3File.getStructureFormatter().addElement(TYPE_EXPERIMENTAL, this.experimental);
        MP3File.getStructureFormatter().addElement(TYPE_CRCDATA, this.crcData);
        MP3File.getStructureFormatter().addElement(TYPE_PADDINGSIZE, this.paddingSize);
        MP3File.getStructureFormatter().closeHeadingElement("header");
        super.createStructureBody();
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    public boolean isUnsynchronization() {
        return this.unsynchronization;
    }

    protected String getArtistId() {
        return "TPE1";
    }

    protected String getAlbumId() {
        return "TALB";
    }

    protected String getTitleId() {
        return "TIT2";
    }

    protected String getTrackId() {
        return "TRCK";
    }

    protected String getYearId() {
        return "TYER";
    }

    protected String getCommentId() {
        return "COMM";
    }

    protected String getGenreId() {
        return "TCON";
    }

    public ID3v23Frame createFrame(String id) {
        return new ID3v23Frame(id);
    }

    public TagField createTagField(ID3v23FieldKey id3Key, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (id3Key == null) {
            throw new KeyNotFoundException();
        }
        return super.doCreateTagField(new AbstractID3v2Tag.FrameAndSubId(id3Key.getFrameId(), id3Key.getSubId()), value);
    }

    public String getFirst(ID3v23FieldKey id3v23FieldKey) throws KeyNotFoundException {
        if (id3v23FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.doGetFirst(new AbstractID3v2Tag.FrameAndSubId(id3v23FieldKey.getFrameId(), id3v23FieldKey.getSubId()));
    }

    public void deleteTagField(ID3v23FieldKey id3v23FieldKey) throws KeyNotFoundException {
        if (id3v23FieldKey == null) {
            throw new KeyNotFoundException();
        }
        super.doDeleteTagField(new AbstractID3v2Tag.FrameAndSubId(id3v23FieldKey.getFrameId(), id3v23FieldKey.getSubId()));
    }

    protected AbstractID3v2Tag.FrameAndSubId getFrameAndSubIdFromGenericKey(TagFieldKey genericKey) {
        ID3v23FieldKey id3v23FieldKey = ID3v23Frames.getInstanceOf().getId3KeyFromGenericKey(genericKey);
        if (id3v23FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return new AbstractID3v2Tag.FrameAndSubId(id3v23FieldKey.getFrameId(), id3v23FieldKey.getSubId());
    }

    protected ID3Frames getID3Frames() {
        return ID3v23Frames.getInstanceOf();
    }
}

