/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.lyrics3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.Lyrics3Image;
import org.jaudiotagger.tag.lyrics3.AbstractLyrics3v2FieldFrameBody;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Fields;

public class FieldFrameBodyIMG
extends AbstractLyrics3v2FieldFrameBody {
    private ArrayList images = new ArrayList();

    public FieldFrameBodyIMG() {
    }

    public FieldFrameBodyIMG(FieldFrameBodyIMG copyObject) {
        super(copyObject);
        for (int i = 0; i < copyObject.images.size(); ++i) {
            Lyrics3Image old = (Lyrics3Image)copyObject.images.get(i);
            this.images.add(new Lyrics3Image(old));
        }
    }

    public FieldFrameBodyIMG(String imageString) {
        this.readString(imageString);
    }

    public FieldFrameBodyIMG(Lyrics3Image image) {
        this.images.add(image);
    }

    public FieldFrameBodyIMG(ByteBuffer byteBuffer) throws InvalidTagException {
        this.read(byteBuffer);
    }

    public String getIdentifier() {
        return "IMG";
    }

    public int getSize() {
        int size = 0;
        for (Object image1 : this.images) {
            Lyrics3Image image = (Lyrics3Image)image1;
            size += image.getSize() + 2;
        }
        return size - 2;
    }

    public boolean isSubsetOf(Object obj) {
        if (!(obj instanceof FieldFrameBodyIMG)) {
            return false;
        }
        ArrayList superset = ((FieldFrameBodyIMG)obj).images;
        for (Object image : this.images) {
            if (superset.contains(image)) continue;
            return false;
        }
        return super.isSubsetOf(obj);
    }

    public void setValue(String value) {
        this.readString(value);
    }

    public String getValue() {
        return this.writeString();
    }

    public void addImage(Lyrics3Image image) {
        this.images.add(image);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldFrameBodyIMG)) {
            return false;
        }
        FieldFrameBodyIMG object = (FieldFrameBodyIMG)obj;
        if (!this.images.equals(object.images)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        return this.images.iterator();
    }

    public void read(ByteBuffer byteBuffer) throws InvalidTagException {
        byte[] buffer = new byte[5];
        byteBuffer.get(buffer, 0, 5);
        int size = Integer.parseInt(new String(buffer, 0, 5));
        if (size == 0 && !TagOptionSingleton.getInstance().isLyrics3KeepEmptyFieldIfRead()) {
            throw new InvalidTagException("Lyircs3v2 Field has size of zero.");
        }
        buffer = new byte[size];
        byteBuffer.get(buffer);
        String imageString = new String(buffer);
        this.readString(imageString);
    }

    public String toString() {
        String str = this.getIdentifier() + " : ";
        for (Object image : this.images) {
            str = str + image.toString() + " ; ";
        }
        return str;
    }

    public void write(RandomAccessFile file) throws IOException {
        int i;
        int size = 0;
        int offset = 0;
        byte[] buffer = new byte[5];
        size = this.getSize();
        String str = Integer.toString(size);
        for (i = 0; i < 5 - str.length(); ++i) {
            buffer[i] = 48;
        }
        offset += 5 - str.length();
        for (i = 0; i < str.length(); ++i) {
            buffer[i + offset] = (byte)str.charAt(i);
        }
        offset += str.length();
        file.write(buffer, 0, 5);
        if (size > 0) {
            str = this.writeString();
            buffer = new byte[str.length()];
            for (i = 0; i < str.length(); ++i) {
                buffer[i] = (byte)str.charAt(i);
            }
            file.write(buffer);
        }
    }

    private void readString(String imageString) {
        Lyrics3Image image;
        String token = "";
        int offset = 0;
        int delim = imageString.indexOf(Lyrics3v2Fields.CRLF);
        this.images = new ArrayList();
        while (delim >= 0) {
            token = imageString.substring(offset, delim);
            image = new Lyrics3Image("Image", this);
            image.setFilename(token);
            this.images.add(image);
            offset = delim + Lyrics3v2Fields.CRLF.length();
            delim = imageString.indexOf(Lyrics3v2Fields.CRLF, offset);
        }
        if (offset < imageString.length()) {
            token = imageString.substring(offset);
            image = new Lyrics3Image("Image", this);
            image.setFilename(token);
            this.images.add(image);
        }
    }

    private String writeString() {
        String str = "";
        for (Object image1 : this.images) {
            Lyrics3Image image = (Lyrics3Image)image1;
            str = str + image.writeString() + Lyrics3v2Fields.CRLF;
        }
        if (str.length() > 2) {
            return str.substring(0, str.length() - 2);
        }
        return str;
    }

    protected void setupObjectList() {
    }
}

