/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public final class FSPA {
    public static final int FSPA_SIZE = 26;
    private int spid;
    private int xaLeft;
    private int yaTop;
    private int xaRight;
    private int yaBottom;
    private short options;
    private static BitField fHdr = BitFieldFactory.getInstance(1);
    private static BitField bx = BitFieldFactory.getInstance(6);
    private static BitField by = BitFieldFactory.getInstance(24);
    private static BitField wr = BitFieldFactory.getInstance(480);
    private static BitField wrk = BitFieldFactory.getInstance(7680);
    private static BitField fRcaSimple = BitFieldFactory.getInstance(8192);
    private static BitField fBelowText = BitFieldFactory.getInstance(16384);
    private static BitField fAnchorLock = BitFieldFactory.getInstance(32768);
    private int cTxbx;

    public FSPA() {
    }

    public FSPA(byte[] bytes, int offset) {
        this.spid = LittleEndian.getInt(bytes, offset);
        this.xaLeft = LittleEndian.getInt(bytes, offset += 4);
        this.yaTop = LittleEndian.getInt(bytes, offset += 4);
        this.xaRight = LittleEndian.getInt(bytes, offset += 4);
        this.yaBottom = LittleEndian.getInt(bytes, offset += 4);
        this.options = LittleEndian.getShort(bytes, offset += 4);
        this.cTxbx = LittleEndian.getInt(bytes, offset += 2);
    }

    public int getSpid() {
        return this.spid;
    }

    public int getXaLeft() {
        return this.xaLeft;
    }

    public int getYaTop() {
        return this.yaTop;
    }

    public int getXaRight() {
        return this.xaRight;
    }

    public int getYaBottom() {
        return this.yaBottom;
    }

    public boolean isFHdr() {
        return fHdr.isSet(this.options);
    }

    public short getBx() {
        return bx.getShortValue(this.options);
    }

    public short getBy() {
        return by.getShortValue(this.options);
    }

    public short getWr() {
        return wr.getShortValue(this.options);
    }

    public short getWrk() {
        return wrk.getShortValue(this.options);
    }

    public boolean isFRcaSimple() {
        return fRcaSimple.isSet(this.options);
    }

    public boolean isFBelowText() {
        return fBelowText.isSet(this.options);
    }

    public boolean isFAnchorLock() {
        return fAnchorLock.isSet(this.options);
    }

    public int getCTxbx() {
        return this.cTxbx;
    }

    public byte[] toByteArray() {
        int offset = 0;
        byte[] buf = new byte[26];
        LittleEndian.putInt(buf, offset, this.spid);
        LittleEndian.putInt(buf, offset += 4, this.xaLeft);
        LittleEndian.putInt(buf, offset += 4, this.yaTop);
        LittleEndian.putInt(buf, offset += 4, this.xaRight);
        LittleEndian.putInt(buf, offset += 4, this.yaBottom);
        LittleEndian.putShort(buf, offset += 4, this.options);
        LittleEndian.putInt(buf, offset += 2, this.cTxbx);
        offset += 4;
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("spid: ").append(this.spid);
        buf.append(", xaLeft: ").append(this.xaLeft);
        buf.append(", yaTop: ").append(this.yaTop);
        buf.append(", xaRight: ").append(this.xaRight);
        buf.append(", yaBottom: ").append(this.yaBottom);
        buf.append(", options: ").append(this.options);
        buf.append(" (fHdr: ").append(this.isFHdr());
        buf.append(", bx: ").append(this.getBx());
        buf.append(", by: ").append(this.getBy());
        buf.append(", wr: ").append(this.getWr());
        buf.append(", wrk: ").append(this.getWrk());
        buf.append(", fRcaSimple: ").append(this.isFRcaSimple());
        buf.append(", fBelowText: ").append(this.isFBelowText());
        buf.append(", fAnchorLock: ").append(this.isFAnchorLock());
        buf.append("), cTxbx: ").append(this.cTxbx);
        return buf.toString();
    }
}

