/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice.excel;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadata;
import org.modeshape.sequencer.msoffice.excel.ExcelMetadataReader;
import org.modeshape.sequencer.msoffice.excel.ExcelSheetMetadata;

public class ExcelMetadataReaderTest {
    private ExcelMetadata excelReader;
    private InputStream imageStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            finally {
                this.imageStream = null;
            }
        }
    }

    protected InputStream getTestDocument(String resourcePath) {
        return this.getClass().getResourceAsStream("/" + resourcePath);
    }

    @Test
    public void shouldBeAbleToCreateMetadataForExcel() throws Exception {
        this.excelReader = ExcelMetadataReader.instance((InputStream)this.getTestDocument("excel.xls"));
        ExcelSheetMetadata sheet2 = this.excelReader.getSheet("MySheet2");
        Assert.assertThat((Object)sheet2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.excelReader.getSheet("Sheet1").getText().startsWith("This is a text"), (Matcher)Is.is((Object)true));
    }
}

