/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class MSOfficeMetadataSequencerTest
extends AbstractSequencerTest {
    private static final Map<String, Integer> WORD_HEADINGS = new LinkedHashMap<String, Integer>(){
        {
            this.put("Test Heading 1", 1);
            this.put("Test Heading 1.1", 2);
            this.put("Test Heading 1.2", 2);
            this.put("Test Heading 1.2.1", 3);
            this.put("Test Heading 2", 1);
            this.put("Test Heading 2.1", 2);
            this.put("Test Heading 2.2", 2);
        }
    };
    private static final Map<String, String> EXCEL_SHEETS = new LinkedHashMap<String, String>(){
        {
            this.put("Sheet1", "This is a text");
            this.put("MySheet2", null);
            this.put("Sheet3", null);
        }
    };

    @Test
    public void shouldSequenceWordFiles() throws Exception {
        this.createNodeWithContentFromFile("word.doc", "word.doc");
        Node sequencedNode = this.getSequencedNode(this.rootNode, "word.doc/msoffice:metadata");
        Assert.assertNotNull((Object)sequencedNode);
        Assert.assertEquals((Object)"msoffice:metadata", (Object)sequencedNode.getPrimaryNodeType().getName());
        Assert.assertEquals((Object)"application/vnd.ms-word", (Object)sequencedNode.getProperty("jcr:mimeType").getString());
        this.assertMetadata(sequencedNode);
        NodeIterator headingsIterator = sequencedNode.getNodes();
        Assert.assertEquals((long)WORD_HEADINGS.size(), (long)headingsIterator.getSize());
        while (headingsIterator.hasNext()) {
            Node heading = headingsIterator.nextNode();
            Assert.assertEquals((Object)"msoffice:heading", (Object)heading.getPrimaryNodeType().getName());
            Integer headingLevel = WORD_HEADINGS.get(heading.getProperty("msoffice:heading_name").getString());
            Assert.assertEquals((long)headingLevel.longValue(), (long)heading.getProperty("msoffice:heading_level").getLong());
        }
    }

    private void assertMetadata(Node sequencedNode) throws RepositoryException {
        Assert.assertEquals((Object)"Test Comment", (Object)sequencedNode.getProperty("msoffice:comment").getString());
        Assert.assertEquals((Object)"Michael Trezzi", (Object)sequencedNode.getProperty("msoffice:author").getString());
        Assert.assertEquals((Object)"jboss, test, dna", (Object)sequencedNode.getProperty("msoffice:keywords").getString());
        Assert.assertEquals((Object)"Test Document", (Object)sequencedNode.getProperty("msoffice:title").getString());
        Assert.assertEquals((Object)"Test Subject", (Object)sequencedNode.getProperty("msoffice:subject").getString());
    }

    @Test
    public void shouldSequenceExcelFiles() throws Exception {
        this.createNodeWithContentFromFile("excel.xls", "excel.xls");
        Node sequencedNode = this.getSequencedNode(this.rootNode, "excel.xls/msoffice:metadata");
        Assert.assertNotNull((Object)sequencedNode);
        Assert.assertEquals((Object)"msoffice:metadata", (Object)sequencedNode.getPrimaryNodeType().getName());
        Assert.assertEquals((Object)"application/vnd.ms-excel", (Object)sequencedNode.getProperty("jcr:mimeType").getString());
        this.assertMetadata(sequencedNode);
        NodeIterator sheetsIterator = sequencedNode.getNodes();
        Assert.assertEquals((long)EXCEL_SHEETS.size(), (long)sheetsIterator.getSize());
        while (sheetsIterator.hasNext()) {
            Node sheet = sheetsIterator.nextNode();
            Assert.assertEquals((Object)"msoffice:xlssheet", (Object)sheet.getPrimaryNodeType().getName());
            String sheetName = sheet.getProperty("msoffice:sheet_name").getString();
            Assert.assertTrue((boolean)EXCEL_SHEETS.containsKey(sheetName));
            String text = EXCEL_SHEETS.get(sheetName);
            if (text == null) continue;
            Assert.assertTrue((boolean)sheet.getProperty("msoffice:text").getString().contains(text));
        }
    }

    @Test
    public void shouldSequencePowerpointFiles() throws Exception {
        this.createNodeWithContentFromFile("powerpoint.ppt", "powerpoint.ppt");
        Node sequencedNode = this.getSequencedNode(this.rootNode, "powerpoint.ppt/msoffice:metadata");
        Assert.assertNotNull((Object)sequencedNode);
        Assert.assertEquals((Object)"msoffice:metadata", (Object)sequencedNode.getPrimaryNodeType().getName());
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint", (Object)sequencedNode.getProperty("jcr:mimeType").getString());
        NodeIterator slidesIterator = sequencedNode.getNodes();
        Assert.assertEquals((long)1L, (long)slidesIterator.getSize());
        Node slide = slidesIterator.nextNode();
        Assert.assertEquals((Object)"msoffice:pptslide", (Object)slide.getPrimaryNodeType().getName());
        Assert.assertEquals((Object)"Test Slide", (Object)slide.getProperty("msoffice:title").getString());
        Assert.assertEquals((Object)"This is some text", (Object)slide.getProperty("msoffice:text").getString());
        Assert.assertEquals((Object)"My notes", (Object)slide.getProperty("msoffice:notes").getString());
    }
}

