/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.POIDocument;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.Chunks;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.NameIdChunks;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.RecipientChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.hsmf.parsers.POIFSChunkParser;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class MAPIMessage
extends POIDocument {
    private Chunks mainChunks;
    private NameIdChunks nameIdChunks;
    private RecipientChunks[] recipientChunks;
    private AttachmentChunks[] attachmentChunks;
    private boolean returnNullOnMissingChunk = false;

    public MAPIMessage() {
        super(new POIFSFileSystem());
    }

    public MAPIMessage(String filename) throws IOException {
        this(new FileInputStream(new File(filename)));
    }

    public MAPIMessage(InputStream in) throws IOException {
        this(new POIFSFileSystem(in));
    }

    public MAPIMessage(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public MAPIMessage(NPOIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    @Deprecated
    public MAPIMessage(DirectoryNode poifsDir, POIFSFileSystem fs) throws IOException {
        this(poifsDir);
    }

    public MAPIMessage(DirectoryNode poifsDir) throws IOException {
        super(poifsDir);
        ChunkGroup[] chunkGroups = POIFSChunkParser.parse(poifsDir);
        ArrayList<AttachmentChunks> attachments = new ArrayList<AttachmentChunks>();
        ArrayList<RecipientChunks> recipients = new ArrayList<RecipientChunks>();
        for (ChunkGroup group : chunkGroups) {
            if (group instanceof Chunks) {
                this.mainChunks = (Chunks)group;
            } else if (group instanceof NameIdChunks) {
                this.nameIdChunks = (NameIdChunks)group;
            } else if (group instanceof RecipientChunks) {
                recipients.add((RecipientChunks)group);
            }
            if (!(group instanceof AttachmentChunks)) continue;
            attachments.add((AttachmentChunks)group);
        }
        this.attachmentChunks = attachments.toArray(new AttachmentChunks[attachments.size()]);
        this.recipientChunks = recipients.toArray(new RecipientChunks[recipients.size()]);
        Arrays.sort(this.attachmentChunks, new AttachmentChunks.AttachmentChunksSorter());
        Arrays.sort(this.recipientChunks, new RecipientChunks.RecipientChunksSorter());
    }

    public String getStringFromChunk(StringChunk chunk) throws ChunkNotFoundException {
        if (chunk == null) {
            if (this.returnNullOnMissingChunk) {
                return null;
            }
            throw new ChunkNotFoundException();
        }
        return chunk.getValue();
    }

    public String getTextBody() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.textBodyChunk);
    }

    public String getHtmlBody() throws ChunkNotFoundException {
        if (this.mainChunks.htmlBodyChunkBinary != null) {
            return this.mainChunks.htmlBodyChunkBinary.getAs7bitString();
        }
        return this.getStringFromChunk(this.mainChunks.htmlBodyChunkString);
    }

    @Deprecated
    public String getHmtlBody() throws ChunkNotFoundException {
        return this.getHtmlBody();
    }

    public String getRtfBody() throws ChunkNotFoundException {
        ByteChunk chunk = this.mainChunks.rtfBodyChunk;
        if (chunk == null) {
            if (this.returnNullOnMissingChunk) {
                return null;
            }
            throw new ChunkNotFoundException();
        }
        try {
            MAPIRtfAttribute rtf = new MAPIRtfAttribute(MAPIProperty.RTF_COMPRESSED, Types.BINARY.getId(), chunk.getValue());
            return rtf.getDataString();
        }
        catch (IOException e) {
            throw new RuntimeException("Shouldn't happen", e);
        }
    }

    public String getSubject() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.subjectChunk);
    }

    public String getDisplayFrom() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayFromChunk);
    }

    public String getDisplayTo() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayToChunk);
    }

    public String getDisplayCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayCCChunk);
    }

    public String getDisplayBCC() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.displayBCCChunk);
    }

    public String getRecipientEmailAddress() throws ChunkNotFoundException {
        return this.toSemicolonList(this.getRecipientEmailAddressList());
    }

    public String[] getRecipientEmailAddressList() throws ChunkNotFoundException {
        if (this.recipientChunks == null || this.recipientChunks.length == 0) {
            throw new ChunkNotFoundException("No recipients section present");
        }
        String[] emails = new String[this.recipientChunks.length];
        for (int i = 0; i < emails.length; ++i) {
            RecipientChunks rc = this.recipientChunks[i];
            String email = rc.getRecipientEmailAddress();
            if (email != null) {
                emails[i] = email;
                continue;
            }
            if (this.returnNullOnMissingChunk) {
                emails[i] = null;
                continue;
            }
            throw new ChunkNotFoundException("No email address holding chunks found for the " + (i + 1) + "th recipient");
        }
        return emails;
    }

    public String getRecipientNames() throws ChunkNotFoundException {
        return this.toSemicolonList(this.getRecipientNamesList());
    }

    public String[] getRecipientNamesList() throws ChunkNotFoundException {
        if (this.recipientChunks == null || this.recipientChunks.length == 0) {
            throw new ChunkNotFoundException("No recipients section present");
        }
        String[] names = new String[this.recipientChunks.length];
        for (int i = 0; i < names.length; ++i) {
            RecipientChunks rc = this.recipientChunks[i];
            String name = rc.getRecipientName();
            if (name == null) {
                throw new ChunkNotFoundException("No display name holding chunks found for the " + (i + 1) + "th recipient");
            }
            names[i] = name;
        }
        return names;
    }

    public void guess7BitEncoding() {
        Pattern p;
        try {
            String[] headers = this.getHeaders();
            if (headers != null && headers.length > 0) {
                p = Pattern.compile("Content-Type:.*?charset=[\"']?([^;'\"]+)[\"']?", 2);
                for (String header : headers) {
                    Matcher m;
                    if (!header.startsWith("Content-Type") || !(m = p.matcher(header)).matches()) continue;
                    String charset = m.group(1);
                    if (!charset.equalsIgnoreCase("utf-8")) {
                        this.set7BitEncoding(charset);
                    }
                    return;
                }
            }
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            Matcher m;
            String html = this.getHmtlBody();
            if (html != null && html.length() > 0 && (m = (p = Pattern.compile("<META\\s+HTTP-EQUIV=\"Content-Type\"\\s+CONTENT=\"text/html;\\s+charset=(.*?)\"")).matcher(html)).find()) {
                String charset = m.group(1);
                this.set7BitEncoding(charset);
                return;
            }
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
    }

    public void set7BitEncoding(String charset) {
        for (Chunk chunk : this.mainChunks.getChunks()) {
            if (!(chunk instanceof StringChunk)) continue;
            ((StringChunk)chunk).set7BitEncoding(charset);
        }
        if (this.nameIdChunks != null) {
            for (Chunk chunk : this.nameIdChunks.getChunks()) {
                if (!(chunk instanceof StringChunk)) continue;
                ((StringChunk)chunk).set7BitEncoding(charset);
            }
        }
        for (RecipientChunks recipientChunks : this.recipientChunks) {
            for (Chunk c : recipientChunks.getAll()) {
                if (!(c instanceof StringChunk)) continue;
                ((StringChunk)c).set7BitEncoding(charset);
            }
        }
    }

    public boolean has7BitEncodingStrings() {
        for (Chunk chunk : this.mainChunks.getChunks()) {
            if (!(chunk instanceof StringChunk) || ((StringChunk)chunk).getType() != Types.ASCII_STRING) continue;
            return true;
        }
        if (this.nameIdChunks != null) {
            for (Chunk chunk : this.nameIdChunks.getChunks()) {
                if (!(chunk instanceof StringChunk) || ((StringChunk)chunk).getType() != Types.ASCII_STRING) continue;
                return true;
            }
        }
        for (RecipientChunks recipientChunks : this.recipientChunks) {
            for (Chunk c : recipientChunks.getAll()) {
                if (!(c instanceof StringChunk) || ((StringChunk)c).getType() != Types.ASCII_STRING) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getHeaders() throws ChunkNotFoundException {
        String headers = this.getStringFromChunk(this.mainChunks.messageHeaders);
        if (headers == null) {
            return null;
        }
        return headers.split("\\r?\\n");
    }

    public String getConversationTopic() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.conversationTopic);
    }

    public String getMessageClass() throws ChunkNotFoundException {
        return this.getStringFromChunk(this.mainChunks.messageClass);
    }

    public Calendar getMessageDate() throws ChunkNotFoundException {
        if (this.mainChunks.submissionChunk != null) {
            return this.mainChunks.submissionChunk.getAcceptedAtTime();
        }
        for (MAPIProperty prop : new MAPIProperty[]{MAPIProperty.CLIENT_SUBMIT_TIME, MAPIProperty.LAST_MODIFICATION_TIME, MAPIProperty.CREATION_TIME}) {
            List<PropertyValue> val = this.mainChunks.getProperties().get(prop);
            if (val == null || val.size() <= 0) continue;
            return ((PropertyValue.TimePropertyValue)val.get(0)).getValue();
        }
        if (this.returnNullOnMissingChunk) {
            return null;
        }
        throw new ChunkNotFoundException();
    }

    public Chunks getMainChunks() {
        return this.mainChunks;
    }

    public RecipientChunks[] getRecipientDetailsChunks() {
        return this.recipientChunks;
    }

    public NameIdChunks getNameIdChunks() {
        return this.nameIdChunks;
    }

    public AttachmentChunks[] getAttachmentFiles() {
        return this.attachmentChunks;
    }

    public void write(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Writing isn't yet supported for HSMF, sorry");
    }

    public boolean isReturnNullOnMissingChunk() {
        return this.returnNullOnMissingChunk;
    }

    public void setReturnNullOnMissingChunk(boolean returnNullOnMissingChunk) {
        this.returnNullOnMissingChunk = returnNullOnMissingChunk;
    }

    private String toSemicolonList(String[] l) {
        StringBuffer list = new StringBuffer();
        boolean first = true;
        for (String s : l) {
            if (s == null) continue;
            if (first) {
                first = false;
            } else {
                list.append("; ");
            }
            list.append(s);
        }
        return list.toString();
    }
}

