/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.msoffice.word;

import java.io.InputStream;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.sequencer.msoffice.word.WordMetadata;
import org.modeshape.sequencer.msoffice.word.WordMetadataReader;

public class WordMetadataTest {
    private static final String[] TEST_HEADERS_TEXT = new String[]{"Test Heading 1", "Test Heading 1.1", "Test Heading 1.2", "Test Heading 1.2.1", "Test Heading 2", "Test Heading 2.1", "Test Heading 2.2"};
    private static final int[] TEST_HEADERS_LEVEL = new int[]{1, 2, 2, 3, 1, 2, 2};

    @Test
    public void shouldBeAbleToParseHeadingsForWord() throws Exception {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("word.doc");
        WordMetadata wordMetadata = WordMetadataReader.instance((InputStream)is);
        List headings = wordMetadata.getHeadings();
        Assert.assertThat((Object)headings.size(), (Matcher)Is.is((Object)TEST_HEADERS_TEXT.length));
        for (int i = 0; i < headings.size(); ++i) {
            Assert.assertThat((Object)((WordMetadata.WordHeading)headings.get(i)).getText(), (Matcher)Is.is((Object)TEST_HEADERS_TEXT[i]));
            Assert.assertThat((Object)((WordMetadata.WordHeading)headings.get(i)).getHeaderLevel(), (Matcher)Is.is((Object)TEST_HEADERS_LEVEL[i]));
        }
    }
}

