/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.odf;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.datatype.Duration;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.meta.Meta;

public class OdfMetadata {
    static final String[] MIME_TYPE_STRINGS = new String[]{"application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.chart", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.spreadsheet-template", "application/vnd.oasis.opendocument.presentation-template", "application/vnd.oasis.opendocument.graphics-template", "application/vnd.oasis.opendocument.chart-template"};
    private Integer pages;
    private Integer sheets;
    private Calendar creationDate;
    private String creator;
    private String description;
    private Integer editingCycles;
    private Long editingTime;
    private String generator;
    private String initialCreator;
    private List<String> keywords = new ArrayList<String>();
    private String language;
    private Calendar modificationDate;
    private String printedBy;
    private Calendar printDate;
    private String title;
    private String subject;
    private InputStream in;

    public OdfMetadata(InputStream inputStream) {
        this.in = inputStream;
    }

    public boolean check() throws Exception {
        Document doc = Document.loadDocument((InputStream)this.in);
        Meta metadata = doc.getOfficeMetadata();
        if (metadata != null) {
            this.title = metadata.getTitle();
            this.subject = metadata.getSubject();
            this.description = metadata.getDescription();
            this.initialCreator = metadata.getInitialCreator();
            this.creator = metadata.getCreator();
            this.language = metadata.getLanguage();
            this.editingCycles = metadata.getEditingCycles();
            this.creationDate = metadata.getCreationDate();
            this.modificationDate = metadata.getDcdate();
            if (metadata.getEditingDuration() != null) {
                Duration duration = metadata.getEditingDuration().getValue();
                this.editingTime = duration.getTimeInMillis(Calendar.getInstance()) / 1000L;
            }
            this.printDate = metadata.getPrintDate();
            this.printedBy = metadata.getPrintedBy();
            if (metadata.getKeywords() != null) {
                this.keywords.addAll(metadata.getKeywords());
            }
            this.generator = metadata.getGenerator();
            if (metadata.getDocumentStatistic() != null) {
                this.pages = metadata.getDocumentStatistic().getPageCount();
            }
        }
        if (doc instanceof PresentationDocument) {
            PresentationDocument presentation = (PresentationDocument)doc;
            this.pages = presentation.getSlideCount();
        }
        if (doc instanceof SpreadsheetDocument) {
            SpreadsheetDocument spreadsheet = (SpreadsheetDocument)doc;
            this.sheets = spreadsheet.getSheetCount();
        }
        return true;
    }

    public Integer getPages() {
        return this.pages;
    }

    public Integer getSheets() {
        return this.sheets;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getEditingCycles() {
        return this.editingCycles;
    }

    public Long getEditingTime() {
        return this.editingTime;
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getInitialCreator() {
        return this.initialCreator;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String getLanguage() {
        return this.language;
    }

    public Calendar getModificationDate() {
        return this.modificationDate;
    }

    public String getPrintedBy() {
        return this.printedBy;
    }

    public Calendar getPrintDate() {
        return this.printDate;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubject() {
        return this.subject;
    }
}

