/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.pdf;

import javax.jcr.Node;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class PdfMetadataSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldSequenceBasicMetadata() throws Exception {
        String filename = "sample.pdf";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/pdf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/pdf"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:pageCount").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:orientation").getString(), (Matcher)Is.is((Object)"portrait"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:encrypted").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:version").getString(), (Matcher)Is.is((Object)"1.4"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:author").getString(), (Matcher)Is.is((Object)"Author"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:creator").getString(), (Matcher)Is.is((Object)"Creator"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:keywords").getString(), (Matcher)Is.is((Object)"Keywords"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:producer").getString(), (Matcher)Is.is((Object)"Producer"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:subject").getString(), (Matcher)Is.is((Object)"Subject"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:title").getString(), (Matcher)Is.is((Object)"Title"));
        Node pageNode = sequencedNode.getNode("pdf:page");
        Assert.assertThat((Object)pageNode.getProperty("pdf:pageNumber").getLong(), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void shouldSequenceXMPMetadata() throws Exception {
        String filename = "sample.pdf";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/pdf/" + filename);
        Assert.assertThat((Object)sequencedNode.hasNode("pdf:xmp"), (Matcher)Is.is((Object)true));
        Node xmpNode = sequencedNode.getNode("pdf:xmp");
        Assert.assertThat((Object)xmpNode.getProperty("xmp:baseURL").getString(), (Matcher)Is.is((Object)"BaseURL"));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:creatorTool").getString(), (Matcher)Is.is((Object)"Creator Tool"));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:rating").getLong(), (Matcher)Is.is((Object)0L));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:identifier").getValues()[0].getString(), (Matcher)Is.is((Object)"Identifier"));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:identifier").getValues()[1].getString(), (Matcher)Is.is((Object)"Second identifier"));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:createDate").getDate().get(1), (Matcher)Is.is((Object)2000));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:metadataDate").getDate().get(1), (Matcher)Is.is((Object)2005));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:modifyDate").getDate().get(1), (Matcher)Is.is((Object)2010));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:nickname").getString(), (Matcher)Is.is((Object)"Nickname"));
        Assert.assertThat((Object)xmpNode.getProperty("xmp:label").getString(), (Matcher)Is.is((Object)"Label"));
    }

    @Test
    public void shouldSequenceEncryptedPdf() throws Exception {
        String filename = "sample-encrypted.pdf";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/pdf/" + filename);
        Assert.assertThat((Object)sequencedNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"application/pdf"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:pageCount").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:orientation").getString(), (Matcher)Is.is((Object)"portrait"));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:encrypted").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)sequencedNode.getProperty("pdf:version").getString(), (Matcher)Is.is((Object)"1.4"));
        Assert.assertThat((Object)sequencedNode.hasProperty("Author"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)sequencedNode.hasNode("pdf:xmp"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSequencePDFWithAttachments() throws Exception {
        String filename = "attachments.pdf";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedNode = this.getOutputNode(this.rootNode, "sequenced/pdf/" + filename);
        Assert.assertThat((Object)sequencedNode.hasNode("pdf:page"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)sequencedNode.hasNode("pdf:page[2]"), (Matcher)Is.is((Object)true));
        Node firstPageNode = sequencedNode.getNode("pdf:page");
        Assert.assertThat((Object)firstPageNode.getProperty("pdf:pageNumber").getLong(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)firstPageNode.hasNode("pdf:attachment"), (Matcher)Is.is((Object)true));
        Node firstAttachmentNode = firstPageNode.getNode("pdf:attachment");
        Assert.assertThat((Object)firstAttachmentNode.getProperty("pdf:name").getString(), (Matcher)Is.is((Object)"redhat-icon.jpg"));
        Assert.assertThat((Object)firstAttachmentNode.getProperty("pdf:subject").getString(), (Matcher)Is.is((Object)"Subject"));
        Assert.assertThat((Object)firstAttachmentNode.getProperty("pdf:creationDate").getDate().get(1), (Matcher)Is.is((Object)2016));
        Assert.assertThat((Object)firstAttachmentNode.getProperty("pdf:modificationDate").getDate().get(1), (Matcher)Is.is((Object)2016));
        Assert.assertThat((Object)firstAttachmentNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"image/jpeg"));
        Assert.assertThat((Object)firstAttachmentNode.getProperty("jcr:data").getBinary().getSize(), (Matcher)Is.is((Object)820L));
        Node secondPageNode = sequencedNode.getNode("pdf:page[2]");
        Assert.assertThat((Object)secondPageNode.getProperty("pdf:pageNumber").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)secondPageNode.hasNode("pdf:attachment"), (Matcher)Is.is((Object)true));
        Node secondAttachmentNode = secondPageNode.getNode("pdf:attachment");
        Assert.assertThat((Object)secondAttachmentNode.getProperty("pdf:name").getString(), (Matcher)Is.is((Object)"linux.mp3"));
        Assert.assertThat((Object)secondAttachmentNode.getProperty("pdf:subject").getString(), (Matcher)Is.is((Object)"Subject"));
        Assert.assertThat((Object)secondAttachmentNode.getProperty("pdf:creationDate").getDate().get(1), (Matcher)Is.is((Object)2016));
        Assert.assertThat((Object)secondAttachmentNode.getProperty("pdf:modificationDate").getDate().get(1), (Matcher)Is.is((Object)2016));
        Assert.assertThat((Object)secondAttachmentNode.getProperty("jcr:mimeType").getString(), (Matcher)Is.is((Object)"audio/mpeg"));
        Assert.assertThat((Object)secondAttachmentNode.getProperty("jcr:data").getBinary().getSize(), (Matcher)Is.is((Object)82969L));
    }
}

