/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.pdf;

import java.awt.print.PageFormat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.printing.PDFPageable;
import org.modeshape.sequencer.pdf.PdfAttachmentMetadata;
import org.modeshape.sequencer.pdf.PdfPageMetadata;

public class PdfBasicMetadata {
    static final String MIME_TYPE_STRING = "application/pdf";
    static final String[] ORIENTATION_STRINGS = new String[]{"landscape", "portrait", "reverse landscape"};
    private Integer pageCount;
    private String author;
    private Calendar creationDate;
    private String creator;
    private String keywords;
    private Calendar modificationDate;
    private String producer;
    private String subject;
    private String title;
    private String orientation;
    private Boolean encrypted;
    private String version;
    private List<PdfPageMetadata> pages = new ArrayList<PdfPageMetadata>();
    private InputStream in;

    public PdfBasicMetadata(InputStream inputStream) {
        this.in = inputStream;
    }

    public boolean check() throws Exception {
        try (PDDocument document = PDDocument.load((InputStream)this.in);){
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            PDFPageable pageable = new PDFPageable(document);
            PageFormat firstPage = pageable.getPageFormat(0);
            this.encrypted = document.isEncrypted();
            this.pageCount = document.getNumberOfPages();
            this.orientation = ORIENTATION_STRINGS[firstPage.getOrientation()];
            this.version = String.valueOf(document.getDocument().getVersion());
            String catalogVersion = catalog.getVersion();
            if (catalogVersion != null && !catalogVersion.isEmpty()) {
                this.version = catalogVersion;
            }
            if (!this.encrypted.booleanValue()) {
                PDDocumentInformation metadata = document.getDocumentInformation();
                this.author = metadata.getAuthor();
                this.creationDate = metadata.getCreationDate();
                this.creator = metadata.getCreator();
                this.keywords = metadata.getKeywords();
                this.modificationDate = metadata.getModificationDate();
                this.producer = metadata.getProducer();
                this.subject = metadata.getSubject();
                this.title = metadata.getTitle();
            }
            int pageNumber = 0;
            for (Object page : catalog.getPages()) {
                PdfPageMetadata pageMetadata = new PdfPageMetadata();
                pageMetadata.setPageNumber(++pageNumber);
                for (PDAnnotation annotation : ((PDPage)page).getAnnotations()) {
                    if (!(annotation instanceof PDAnnotationFileAttachment)) continue;
                    PdfAttachmentMetadata attachmentMetadata = new PdfAttachmentMetadata();
                    PDAnnotationFileAttachment fann = (PDAnnotationFileAttachment)annotation;
                    PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)fann.getFile();
                    PDEmbeddedFile embeddedFile = fileSpec.getEmbeddedFile();
                    attachmentMetadata.setSubject(fann.getSubject());
                    attachmentMetadata.setName(fileSpec.getFilename());
                    attachmentMetadata.setCreationDate(embeddedFile.getCreationDate());
                    attachmentMetadata.setModificationDate(embeddedFile.getModDate());
                    attachmentMetadata.setMimeType(embeddedFile.getSubtype());
                    attachmentMetadata.setData(embeddedFile.toByteArray());
                    pageMetadata.addAttachment(attachmentMetadata);
                }
                this.pages.add(pageMetadata);
            }
            boolean bl = true;
            return bl;
        }
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public String getAuthor() {
        return this.author;
    }

    public Calendar getCreationDate() {
        return this.creationDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public Calendar getModificationDate() {
        return this.modificationDate;
    }

    public String getProducer() {
        return this.producer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public String getVersion() {
        return this.version;
    }

    public List<PdfPageMetadata> getPages() {
        return this.pages;
    }

    public void addPage(PdfPageMetadata page) {
        this.pages.add(page);
    }
}

