/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid.model;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceRegistry;
import javax.xml.stream.XMLStreamReader;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.sequencer.teiid.TeiidI18n;
import org.modeshape.sequencer.teiid.model.ModelSequencer;
import org.modeshape.sequencer.teiid.model.ReferenceResolver;
import org.modeshape.sequencer.teiid.xmi.XmiAttribute;
import org.modeshape.sequencer.teiid.xmi.XmiBasePart;
import org.modeshape.sequencer.teiid.xmi.XmiElement;
import org.modeshape.sequencer.teiid.xmi.XmiReader;

class ModelReader
extends XmiReader
implements Comparable<ModelReader> {
    private static final long DEFAULT_MAX_SET_SIZE = 100L;
    private static final boolean DEFAULT_SUPPORTS_DISTINCT = true;
    private static final boolean DEFAULT_SUPPORTS_JOIN = true;
    private static final boolean DEFAULT_SUPPORTS_ORDER_BY = true;
    private static final boolean DEFAULT_SUPPORTS_OUTER_JOIN = true;
    private static final boolean DEFAULT_SUPPORTS_WHERE_ALL = true;
    private static final boolean DEFAULT_VISIBLE = true;
    private static final Logger LOGGER = Logger.getLogger(ModelReader.class);
    private final NamespaceRegistry registry;
    private final ReferenceResolver resolver;

    public ModelReader(String path, ReferenceResolver resolver, NamespaceRegistry registry) {
        super(path);
        CheckArg.isNotNull((Object)resolver, (String)"resolver");
        this.registry = registry;
        this.resolver = resolver;
    }

    @Override
    protected void addAttribute(XmiElement element, XmiAttribute newAttribute) {
        String value;
        this.ensureNamespacePrefixIsValid(newAttribute);
        super.addAttribute(element, newAttribute);
        if ("uuid".equals(newAttribute.getName()) && "http://www.omg.org/XMI".equals(newAttribute.getNamespaceUri()) && !StringUtil.isBlank((String)(value = newAttribute.getValue())) && value.startsWith("mmuuid:")) {
            newAttribute.setValue(value.substring("mmuuid:".length()));
        }
    }

    @Override
    protected void addChild(XmiElement parent, XmiElement newChild) {
        super.addChild(parent, newChild);
        if (!StringUtil.isBlank((String)newChild.getUuid())) {
            this.resolver.record(newChild.getUuid(), newChild);
        }
    }

    @Override
    protected void addElement(XmiElement newElement) {
        this.ensureNamespacePrefixIsValid(newElement);
        super.addElement(newElement);
        if (!StringUtil.isBlank((String)newElement.getUuid())) {
            this.resolver.record(newElement.getUuid(), newElement);
        }
    }

    @Override
    public int compareTo(ModelReader that) {
        if (that == null) {
            return 1;
        }
        if (that == this) {
            return 0;
        }
        String thatPath = that.getPath();
        for (XmiElement modelImport : this.getModelImports()) {
            if (!thatPath.equals(modelImport.getAttributeValue("name", "http://www.metamatrix.com/metamodels/Core"))) continue;
            return -1;
        }
        String thisPath = this.getPath();
        for (XmiElement modelImport : that.getModelImports()) {
            if (!thisPath.equals(modelImport.getAttributeValue("name", "http://www.metamatrix.com/metamodels/Core"))) continue;
            return -1;
        }
        return this.getModelImports().size() - that.getModelImports().size();
    }

    private void ensureNamespacePrefixIsValid(XmiBasePart xmiPart) {
        assert (xmiPart != null);
        String nsUri = xmiPart.getNamespaceUri();
        if (!StringUtil.isBlank((String)nsUri)) {
            try {
                String registeredPrefix = this.registry.getPrefix(nsUri);
                if (!registeredPrefix.equals(xmiPart.getNamespacePrefix())) {
                    xmiPart.setNamespacePrefix(registeredPrefix);
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, (I18nResource)TeiidI18n.namespaceUriNotFoundInRegistry, new Object[]{nsUri, this.getPath()});
            }
        }
    }

    public String getDescription() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return null;
        }
        return modelAnnotation.getAttributeValue("description", "http://www.metamatrix.com/metamodels/Core");
    }

    private XmiElement getElement(String name, String namespaceUri) {
        for (XmiElement element : this.getElements()) {
            if (!name.equals(element.getName()) || !namespaceUri.equals(element.getNamespaceUri())) continue;
            return element;
        }
        return null;
    }

    public long getMaxSetSize() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return 100L;
        }
        String maxSetSize = modelAnnotation.getAttributeValue("maxSetSize", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)maxSetSize)) {
            return 100L;
        }
        return Long.parseLong(maxSetSize);
    }

    private XmiElement getModelAnnotation() {
        return this.getElement("ModelAnnotation", "http://www.metamatrix.com/metamodels/Core");
    }

    public List<XmiElement> getModelImports() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return null;
        }
        ArrayList<XmiElement> imports = new ArrayList<XmiElement>();
        for (XmiElement kid : modelAnnotation.getChildren()) {
            if (!"modelImports".equals(kid.getName()) || !"http://www.metamatrix.com/metamodels/Core".equals(kid.getNamespaceUri())) continue;
            imports.add(kid);
        }
        return imports;
    }

    public String getModelType() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return null;
        }
        return modelAnnotation.getAttributeValue("modelType", "http://www.metamatrix.com/metamodels/Core");
    }

    public String getNameInSource() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return null;
        }
        return modelAnnotation.getAttributeValue("nameInSource", "http://www.metamatrix.com/metamodels/Core");
    }

    public String getPrimaryMetamodelUri() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return null;
        }
        return modelAnnotation.getAttributeValue("primaryMetamodelUri", "http://www.metamatrix.com/metamodels/Core");
    }

    public String getProducerName() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return null;
        }
        return modelAnnotation.getAttributeValue("ProducerName", "http://www.metamatrix.com/metamodels/Core");
    }

    public String getProducerVersion() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return null;
        }
        return modelAnnotation.getAttributeValue("ProducerVersion", "http://www.metamatrix.com/metamodels/Core");
    }

    @Override
    protected XmiElement handleEndElement(XMLStreamReader streamReader) {
        XmiElement endElement = super.handleEndElement(streamReader);
        if ("XMI".equals(streamReader.getLocalName()) || "ModelAnnotation".equals(endElement.getName()) && !ModelSequencer.shouldSequence(this)) {
            this.stop();
        }
        return endElement;
    }

    public boolean isVisible() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return true;
        }
        String visible = modelAnnotation.getAttributeValue("visible", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)visible)) {
            return true;
        }
        return Boolean.parseBoolean(visible);
    }

    @Override
    protected XmiElement pop(XMLStreamReader streamReader) {
        if (!"XMI".equals(streamReader.getLocalName()) || this.getStackSize() != 0) {
            return super.pop(streamReader);
        }
        return null;
    }

    @Override
    protected void push(XmiElement element) {
        if (!"XMI".equals(element.getName()) || this.getStackSize() != 0) {
            super.push(element);
        }
    }

    public void readModel(InputStream stream) throws Exception {
        CheckArg.isNotNull((Object)stream, (String)"stream");
        long startTime = System.currentTimeMillis();
        List<XmiElement> elements = super.read(stream);
        for (XmiElement xmiElement : elements) {
            this.debug("====root model element=" + xmiElement.getName());
        }
        this.debug("");
        for (Map.Entry entry : this.resolver.getUuidMappings().entrySet()) {
            this.debug((String)entry.getKey() + '=' + entry.getValue());
        }
        this.debug("");
        for (String string : this.resolver.getUnresolved().keySet()) {
            this.debug("**** unresolved " + string);
        }
        this.debug("\n\nmodel read time=" + (System.currentTimeMillis() - startTime));
    }

    public boolean supportsDistinct() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return true;
        }
        String supports = modelAnnotation.getAttributeValue("supportsDistinct", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)supports)) {
            return true;
        }
        return Boolean.parseBoolean(supports);
    }

    public boolean supportsJoin() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return true;
        }
        String supports = modelAnnotation.getAttributeValue("supportsJoin", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)supports)) {
            return true;
        }
        return Boolean.parseBoolean(supports);
    }

    public boolean supportsOrderBy() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return true;
        }
        String supports = modelAnnotation.getAttributeValue("supportsOrderBy", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)supports)) {
            return true;
        }
        return Boolean.parseBoolean(supports);
    }

    public boolean supportsOuterJoin() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return true;
        }
        String supports = modelAnnotation.getAttributeValue("supportsOuterJoin", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)supports)) {
            return true;
        }
        return Boolean.parseBoolean(supports);
    }

    public boolean supportsWhereAll() {
        XmiElement modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation == null) {
            return true;
        }
        String supports = modelAnnotation.getAttributeValue("supportsWhereAll", "http://www.metamatrix.com/metamodels/Core");
        if (StringUtil.isBlank((String)supports)) {
            return true;
        }
        return Boolean.parseBoolean(supports);
    }
}

