/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.text;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.junit.Assert;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public abstract class AbstractTextSequencerTest
extends AbstractSequencerTest {
    protected static final String[] TEST_COLUMNS = new String[]{"foo", "bar", "baz"};

    protected void assertRowsWithCustomRowFactory(String sequencedRootPath) throws Exception {
        int ROW_COUNT = 6;
        Node sequencedNode = this.getSequencedNode(this.rootNode, sequencedRootPath);
        Assert.assertNotNull((Object)sequencedNode);
        Assert.assertEquals((long)6L, (long)sequencedNode.getNodes().getSize());
        for (int rowIndex = 1; rowIndex <= 6; ++rowIndex) {
            Node row = this.assertRow(sequencedNode, rowIndex, new String[0]);
            String[] expectedColumns = TEST_COLUMNS;
            for (int colIndex = 0; colIndex < expectedColumns.length; ++colIndex) {
                Assert.assertEquals((Object)expectedColumns[colIndex], (Object)row.getProperty("text:data" + colIndex).getString());
            }
        }
    }

    protected void assertFileWithMissingRecords(String filePath) throws Exception {
        int ROW_COUNT = 6;
        Node sequencedNode = this.getSequencedNode(this.rootNode, filePath);
        Assert.assertNotNull((Object)sequencedNode);
        Assert.assertEquals((long)6L, (long)sequencedNode.getNodes().getSize());
        for (int rowIndex = 1; rowIndex <= 6; ++rowIndex) {
            if (rowIndex == 3) {
                this.assertRow(sequencedNode, rowIndex, new String[]{"foo"});
                continue;
            }
            this.assertRow(sequencedNode, rowIndex, TEST_COLUMNS);
        }
    }

    protected void assertRows(String rootSequencedNodePath, int rowsCount, String[] expectedColumnData) throws Exception {
        Node sequencedNode = this.getSequencedNode(this.rootNode, rootSequencedNodePath);
        Assert.assertNotNull((Object)sequencedNode);
        Assert.assertEquals((long)rowsCount, (long)sequencedNode.getNodes().getSize());
        for (int rowIndex = 1; rowIndex <= rowsCount; ++rowIndex) {
            this.assertRow(sequencedNode, rowIndex, expectedColumnData);
        }
    }

    protected Node assertRow(Node rootSequencedNode, int index, String[] expectedColumnData) throws Exception {
        Node row = index == 1 ? rootSequencedNode.getNode("text:row") : rootSequencedNode.getNode("text:row[" + index + "]");
        Assert.assertEquals((Object)"nt:unstructured", (Object)row.getPrimaryNodeType().getName());
        Assert.assertEquals((long)expectedColumnData.length, (long)row.getNodes().getSize());
        for (int colIndex = 0; colIndex < expectedColumnData.length; ++colIndex) {
            this.assertColumn(row, colIndex, expectedColumnData[colIndex]);
        }
        return row;
    }

    protected void assertColumn(Node row, int index, String data) throws RepositoryException {
        Node column = row.getNode("text:column[" + (index + 1) + "]");
        Assert.assertEquals((Object)"nt:unstructured", (Object)column.getPrimaryNodeType().getName());
        ArrayList<String> mixinNames = new ArrayList<String>();
        for (NodeType mixinType : column.getMixinNodeTypes()) {
            mixinNames.add(mixinType.getName());
        }
        Assert.assertTrue((boolean)mixinNames.contains("text:column"));
        Assert.assertEquals((Object)data, (Object)column.getProperty("text:data").getString());
    }
}

