/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.text.DefaultRowFactory;
import org.modeshape.sequencer.text.RowFactory;

@ThreadSafe
public abstract class AbstractTextSequencer
extends Sequencer {
    private String rowFactoryClassName = null;
    private String commentMarker = null;
    private int maximumLinesToRead = -1;

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("sequencer-text.cnd", nodeTypeManager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        int rowCount = 0;
        RowFactory rowFactory = this.createRowFactory();
        String line = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(binaryValue.getStream()));
            while ((line = reader.readLine()) != null) {
                if (this.isComment(line) || !this.shouldReadLine(++rowCount)) continue;
                String[] columns = this.parseLine(line);
                rowFactory.recordRow(outputNode, columns);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                this.getLogger().warn((Throwable)e, "Cannot close reader ", new Object[0]);
            }
        }
        return true;
    }

    private boolean isComment(String line) {
        return this.commentMarker != null && line.startsWith(this.commentMarker);
    }

    private boolean shouldReadLine(int rowCount) {
        return this.maximumLinesToRead < 0 || rowCount <= this.maximumLinesToRead;
    }

    public void setCommentMarker(String commentMarker) {
        this.commentMarker = commentMarker;
    }

    public String getCommentMarker() {
        return this.commentMarker;
    }

    public int getMaximumLinesToRead() {
        return this.maximumLinesToRead;
    }

    public void setMaximumLinesToRead(int maximumLinesToRead) {
        this.maximumLinesToRead = maximumLinesToRead;
    }

    public String getRowFactoryClassName() {
        return this.rowFactoryClassName;
    }

    public void setRowFactoryClassName(String rowFactoryClassName) {
        this.rowFactoryClassName = rowFactoryClassName;
    }

    protected abstract String[] parseLine(String var1);

    private RowFactory createRowFactory() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (this.rowFactoryClassName == null) {
            return new DefaultRowFactory();
        }
        Class<?> rowFactoryClass = Class.forName(this.rowFactoryClassName);
        return (RowFactory)rowFactoryClass.newInstance();
    }
}

