/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.Node;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.SizeMeasuringInputStream;
import org.modeshape.common.util.SizeMeasuringReader;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.sramp.AbstractResolvingReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@NotThreadSafe
public abstract class WsdlReader<T>
extends AbstractResolvingReader {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final String baseUri;

    public WsdlReader(Sequencer.Context context, String baseUri) {
        super(context);
        this.baseUri = baseUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputSource source, Node outputNode) throws Exception {
        this.logger.debug("Processing XSD '{}'", (Object)outputNode.getName());
        Reader reader = null;
        InputStream stream = null;
        try {
            AtomicLong contentSize = new AtomicLong();
            if (source.getCharacterStream() != null) {
                reader = new SizeMeasuringReader(source.getCharacterStream(), contentSize);
                source = new InputSource(reader);
            } else {
                stream = new SizeMeasuringInputStream(source.getByteStream(), contentSize);
                source = new InputSource(stream);
            }
            T result = this.parse(source);
            this.process(result, outputNode, contentSize.get());
        }
        finally {
            assert (reader != null || stream != null);
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.warn("Cannot close reader ", (Throwable)e);
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.logger.warn("Cannot close stream ", (Throwable)e);
                }
            }
        }
    }

    protected abstract T parse(InputSource var1) throws Exception;

    protected abstract void process(T var1, Node var2, long var3) throws Exception;
}

