/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.wsdl;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.sramp.AbstractSrampSequencer;
import org.modeshape.sequencer.wsdl.Wsdl11Reader;
import org.modeshape.sequencer.xsd.XsdSequencer;

public class WsdlSequencer
extends AbstractSrampSequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.initialize(registry, nodeTypeManager);
        this.registerNodeTypes(XsdSequencer.class.getResourceAsStream("xsd.cnd"), nodeTypeManager, true);
        this.registerNodeTypes("wsdl.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"application/wsdl+xml", "application/xml", "text/xml"});
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        if (outputNode.isNew()) {
            outputNode.setPrimaryType("wsdl:wsdlDocument");
        } else {
            outputNode = outputNode.addNode("wsdl:wsdlDocument", "wsdl:wsdlDocument");
        }
        String baseUri = inputProperty.getParent().getPath();
        try (InputStream stream = binaryValue.getStream();){
            new Wsdl11Reader(context, baseUri).read(stream, outputNode);
        }
        return true;
    }

    public static final class MimeTypeConstants {
        public static final String WSDL = "application/wsdl+xml";
        public static final String APPLICATION_XML = "application/xml";
        public static final String TEXT_XML = "text/xml";
    }
}

