/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.xml;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.sequencer.xml.XmlSequencer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class XmlSequencerHandler
extends DefaultHandler2 {
    private static final Logger LOGGER = Logger.getLogger(XmlSequencerHandler.class);
    public static TextDecoder DEFAULT_DECODER = new XmlNameEncoder();
    public static XmlSequencer.AttributeScoping DEFAULT_ATTRIBUTE_SCOPING = XmlSequencer.AttributeScoping.USE_DEFAULT_NAMESPACE;
    protected final TextDecoder decoder;
    private final Map<String, LinkedList<String>> prefixStackByUri = new HashMap<String, LinkedList<String>>();
    private final XmlSequencer.AttributeScoping attributeScoping;
    private Node currentNode;
    private Session session;
    private String currentEntityName;
    private StringBuilder cDataContent;
    private StringBuilder contentBuilder;
    private final Map<String, String> entityValues = new HashMap<String, String>();

    XmlSequencerHandler(Node rootNode, XmlSequencer.AttributeScoping scoping) throws RepositoryException {
        CheckArg.isNotNull((Object)rootNode, (String)"outputNode");
        this.currentNode = rootNode;
        this.session = this.currentNode.getSession();
        this.decoder = DEFAULT_DECODER;
        this.attributeScoping = scoping != null ? scoping : DEFAULT_ATTRIBUTE_SCOPING;
    }

    private void startNode(String name, String primaryType) throws RepositoryException {
        if (this.contentBuilder != null) {
            this.endContent();
        }
        this.currentNode = this.currentNode.addNode(name, primaryType);
    }

    private void endNode() throws RepositoryException {
        this.currentNode = this.currentNode.getParent();
    }

    protected void endContent() throws RepositoryException {
        String content = StringUtil.normalize((String)this.contentBuilder.toString());
        this.contentBuilder = null;
        if (content.length() > 0) {
            this.startNode("modexml:elementContent", "modexml:elementContent");
            this.currentNode.setProperty("modexml:elementContent", content);
            this.endNode();
        }
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.currentNode.setPrimaryType("modexml:document");
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            this.currentNode.setProperty("modedtd:name", name);
            this.currentNode.setProperty("modedtd:publicId", publicId);
            this.currentNode.setProperty("modedtd:systemId", systemId);
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        try {
            this.startNode("modedtd:entity", "modedtd:entity");
            this.currentNode.setProperty("modedtd:name", name);
            if (publicId != null) {
                this.currentNode.setProperty("modedtd:publicId", publicId);
            }
            if (systemId != null) {
                this.currentNode.setProperty("modedtd:systemId", systemId);
            }
            this.endNode();
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void internalEntityDecl(String name, String value) throws SAXException {
        try {
            this.startNode("modedtd:entity", "modedtd:entity");
            this.currentNode.setProperty("modedtd:name", name);
            this.currentNode.setProperty("modedtd:value", value);
            this.entityValues.put(name, value);
            this.endNode();
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.startNode("modexml:processingInstruction", "modexml:processingInstruction");
            this.currentNode.setProperty("modexml:target", target.trim());
            if (data != null) {
                this.currentNode.setProperty("modexml:processingInstructionContent", data.trim());
            }
            this.endNode();
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            if (this.isUriRegistered(uri) && !StringUtil.isBlank((String)prefix)) {
                this.session.setNamespacePrefix(prefix, uri);
            } else {
                NamespaceRegistry namespaceRegistry = (NamespaceRegistry)this.session.getWorkspace().getNamespaceRegistry();
                if (StringUtil.isBlank((String)prefix)) {
                    prefix = namespaceRegistry.registerNamespace(uri);
                } else {
                    namespaceRegistry.registerNamespace(prefix, uri);
                }
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        if (prefixStack == null) {
            prefixStack = new LinkedList();
            this.prefixStackByUri.put(uri, prefixStack);
        }
        prefixStack.addFirst(prefix);
    }

    private boolean isUriRegistered(String uri) throws RepositoryException {
        try {
            this.session.getNamespacePrefix(uri);
            return true;
        }
        catch (NamespaceException e) {
            return false;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        CheckArg.isNotNull((Object)prefix, (String)"prefix");
        if (StringUtil.isBlank((String)prefix)) {
            return;
        }
        try {
            String uri = this.session.getNamespaceURI(prefix);
            LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
            assert (prefixStack != null);
            assert (!prefixStack.isEmpty());
            String existingPrefix = prefixStack.removeFirst();
            assert (prefix.equals(existingPrefix));
            if (prefixStack.isEmpty()) {
                this.prefixStackByUri.remove(uri);
            } else {
                String previous = prefixStack.getFirst();
                this.session.setNamespacePrefix(previous, uri);
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void startEntity(String name) {
        this.currentEntityName = name;
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() throws SAXException {
        try {
            if (this.contentBuilder != null) {
                this.endContent();
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        this.cDataContent = new StringBuilder();
    }

    @Override
    public void endCDATA() throws SAXException {
        try {
            this.startNode("modexml:cData", "modexml:cData");
            this.currentNode.setProperty("modexml:cDataContent", this.cDataContent.toString());
            this.endNode();
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        this.cDataContent = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String content = String.valueOf(ch, start, length);
        if (this.cDataContent != null) {
            this.cDataContent.append(ch, start, length);
        } else {
            if (this.contentBuilder == null) {
                this.contentBuilder = new StringBuilder();
            }
            if (this.currentEntityName != null) {
                this.contentBuilder.append('&').append(this.currentEntityName).append(';');
                String entityValue = this.entityValues.get(this.currentEntityName);
                if (!content.equals(entityValue) && entityValue != null && entityValue.length() < content.length()) {
                    String extraContent = content.substring(entityValue.length());
                    this.contentBuilder.append(extraContent);
                }
                this.currentEntityName = null;
            } else {
                this.contentBuilder.append(content);
            }
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        try {
            this.startNode("modexml:comment", "modexml:comment");
            this.currentNode.setProperty("modexml:commentContent", String.valueOf(ch, start, length).trim());
            this.endNode();
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        assert (localName != null);
        try {
            String nodeName = this.createAttributeName(uri, localName);
            this.startNode(nodeName, "modexml:element");
            int len = attributes.getLength();
            for (int i = 0; i != len; ++i) {
                String attributeLocalName = attributes.getLocalName(i);
                String attributeUri = attributes.getURI(i);
                String attributeName = null;
                if ((attributeUri == null || attributeUri.length() == 0) && attributes.getQName(i).indexOf(58) == -1) {
                    switch (this.attributeScoping) {
                        case INHERIT_ELEMENT_NAMESPACE: {
                            attributeName = this.createAttributeName(uri, attributeLocalName);
                            break;
                        }
                        case USE_DEFAULT_NAMESPACE: {
                            attributeName = this.createAttributeName(null, attributeLocalName);
                        }
                    }
                } else {
                    attributeName = this.createAttributeName(attributeUri, attributeLocalName);
                }
                assert (attributeName != null);
                if ("jcr:name".equals(attributeName)) continue;
                this.currentNode.setProperty(attributeName, attributes.getValue(i));
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    private String createAttributeName(String uri, String localName) throws RepositoryException {
        if (StringUtil.isBlank((String)uri)) {
            return this.decoder.decode(localName.trim());
        }
        String prefix = this.session.getNamespacePrefix(uri);
        assert (prefix != null);
        return prefix + ":" + this.decoder.decode(localName.trim());
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        try {
            if (this.contentBuilder != null) {
                this.endContent();
            }
            this.endNode();
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void warning(SAXParseException warning) {
        LOGGER.debug((Throwable)warning, "SAX warning:", new Object[0]);
    }

    @Override
    public void error(SAXParseException error) {
        LOGGER.debug((Throwable)error, "SAX error:", new Object[0]);
    }
}

