/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.JcrNtLexicon;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.BinaryFactory;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencer;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.zip.ZipLexicon;

public class ZipSequencer
implements StreamSequencer {
    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        BinaryFactory binaryFactory = context.getValueFactories().getBinaryFactory();
        DateTimeFactory dateFactory = context.getValueFactories().getDateFactory();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        NameFactory nameFactory = context.getValueFactories().getNameFactory();
        try {
            ZipInputStream in = new ZipInputStream(stream);
            ZipEntry entry = in.getNextEntry();
            byte[] buf = new byte[1024];
            Path zipPath = pathFactory.createRelativePath(new Name[]{ZipLexicon.CONTENT});
            output.setProperty(zipPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ZipLexicon.CONTENT});
            while (entry != null) {
                Path entryPath = zipPath;
                String entryName = entry.getName();
                for (String segment : entryName.split(File.separator)) {
                    entryPath = pathFactory.create(entryPath, new Name[]{(Name)nameFactory.create(segment)});
                }
                if (entry.isDirectory()) {
                    output.setProperty(entryPath, JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FOLDER});
                } else {
                    int n;
                    output.setProperty(entryPath, JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FILE});
                    Path contentPath = pathFactory.create(entryPath, new Name[]{JcrLexicon.CONTENT});
                    output.setProperty(contentPath, JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.RESOURCE});
                    ByteArrayOutputStream baout = new ByteArrayOutputStream();
                    while ((n = in.read(buf, 0, 1024)) > -1) {
                        baout.write(buf, 0, n);
                    }
                    byte[] bytes = baout.toByteArray();
                    output.setProperty(contentPath, JcrLexicon.DATA, new Object[]{binaryFactory.create(bytes)});
                    output.setProperty(contentPath, JcrLexicon.ENCODED, new Object[]{"binary"});
                    output.setProperty(contentPath, JcrLexicon.LAST_MODIFIED, new Object[]{((DateTime)dateFactory.create(entry.getTime())).toString()});
                    output.setProperty(contentPath, JcrLexicon.MIMETYPE, new Object[]{"application/octet-stream"});
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

