/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.zip;

import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.graph.JcrLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.sequencer.MockSequencerContext;
import org.modeshape.graph.sequencer.MockSequencerOutput;
import org.modeshape.graph.sequencer.SequencerOutput;
import org.modeshape.graph.sequencer.StreamSequencerContext;
import org.modeshape.sequencer.zip.ZipLexicon;
import org.modeshape.sequencer.zip.ZipSequencer;

public class ZipSequencerTest {
    private InputStream imageStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            finally {
                this.imageStream = null;
            }
        }
    }

    protected InputStream getTestZip(String resourcePath) {
        return this.getClass().getResourceAsStream("/" + resourcePath);
    }

    @Test
    public void shouldBeAbleToExtractZip() {
        InputStream is = this.getTestZip("testzip.zip");
        ZipSequencer zs = new ZipSequencer();
        MockSequencerContext context = new MockSequencerContext();
        MockSequencerOutput seqtest = new MockSequencerOutput((StreamSequencerContext)context);
        zs.sequence(is, (SequencerOutput)seqtest, (StreamSequencerContext)context);
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        NameFactory nameFactory = context.getValueFactories().getNameFactory();
        ValueFactory stringFactory = context.getValueFactories().getStringFactory();
        Name folderName = (Name)nameFactory.create("test subfolder");
        Name fileName = (Name)nameFactory.create("test2.txt");
        Path nodePath = pathFactory.createRelativePath(new Name[]{ZipLexicon.CONTENT, folderName, fileName, JcrLexicon.CONTENT});
        Property property = seqtest.getProperty(nodePath, JcrLexicon.DATA);
        Assert.assertThat((Object)property, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)stringFactory.create(property.getFirstValue()), (Matcher)Is.is((Object)"This is a test content of file2\n"));
    }
}

