/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.zip;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;

public class ZipSequencerTest
extends AbstractSequencerTest {
    @Test
    public void shouldSequenceZip1() throws Exception {
        String filename = "testzip.zip";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedZip = this.getSequencedNode(this.rootNode, "zip/" + filename);
        Assert.assertNotNull((Object)sequencedZip);
        Assert.assertEquals((Object)"zip:file", (Object)sequencedZip.getPrimaryNodeType().getName());
        Assert.assertEquals((long)2L, (long)sequencedZip.getNodes().getSize());
        this.assertFile(sequencedZip, "test1.txt", "This is a test content of file 1\n");
        Node folder = sequencedZip.getNode("test subfolder");
        Assert.assertEquals((long)1L, (long)folder.getNodes().getSize());
        Assert.assertEquals((Object)"nt:folder", (Object)folder.getPrimaryNodeType().getName());
        this.assertFile(folder, "test2.txt", "This is a test content of file2\n");
    }

    private void assertFile(Node parentNode, String relativePath, String expectedContent) throws RepositoryException, IOException {
        Node file = parentNode.getNode(relativePath);
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((long)1L, (long)file.getNodes().getSize());
        Assert.assertEquals((Object)"nt:file", (Object)file.getPrimaryNodeType().getName());
        Node fileContent = file.getNode("jcr:content");
        Assert.assertNotNull((Object)fileContent);
        Assert.assertEquals((Object)"text/plain", (Object)fileContent.getProperty("jcr:mimeType").getString());
        Binary fileData = fileContent.getProperty("jcr:data").getBinary();
        Assert.assertNotNull((Object)fileData);
        if (expectedContent != null) {
            Assert.assertEquals((Object)expectedContent, (Object)IoUtil.read((InputStream)fileData.getStream()));
        }
    }

    @Test
    public void shouldSequenceZip2() throws Exception {
        String filename = "test-files.zip";
        this.createNodeWithContentFromFile(filename, filename);
        Node sequencedZip = this.getSequencedNode(this.rootNode, "zip/" + filename);
        Assert.assertNotNull((Object)sequencedZip);
        Assert.assertEquals((Object)"zip:file", (Object)sequencedZip.getPrimaryNodeType().getName());
        String path = "/zip/test-files.zip";
        this.assertNode(path + "/MODE-966-fix.patch", "nt:file");
        this.assertNode(path + "/MODE-966-fix.patch/jcr:content", "nt:resource");
        this.assertNode(path + "/testFolder", "nt:folder");
        this.assertNode(path + "/testFolder/MODE-962-fix.patch", "nt:file");
        this.assertNode(path + "/testFolder/MODE-962-fix.patch/jcr:content", "nt:resource");
        this.assertNode(path + "/testFolder/testInnerFolder", "nt:folder");
        this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix.patch", "nt:file");
        this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix.patch/jcr:content", "nt:resource");
        this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix2.patch", "nt:file");
        this.assertNode(path + "/testFolder/testInnerFolder/MODE-960-fix2.patch/jcr:content", "nt:resource");
    }
}

