/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;

public class ZipSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        super.registerNodeTypes("zip.cnd", nodeTypeManager, true);
        this.registerDefaultMimeTypes(new String[]{"application/java-archive", "application/zip"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        boolean bl;
        block8: {
            javax.jcr.Binary binaryValue = inputProperty.getBinary();
            CheckArg.isNotNull((Object)binaryValue, (String)"binary");
            ZipInputStream zipInputStream = null;
            try {
                zipInputStream = new ZipInputStream(binaryValue.getStream());
                ZipEntry entry = zipInputStream.getNextEntry();
                outputNode = this.createTopLevelNode(outputNode);
                while (entry != null) {
                    entry = this.sequenceZipEntry(outputNode, context, zipInputStream, entry);
                }
                bl = true;
                if (zipInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception e) {
                        this.getLogger().warn("Cannot close zip input stream", new Object[]{e});
                    }
                }
                throw throwable;
            }
            try {
                zipInputStream.close();
            }
            catch (Exception e) {
                this.getLogger().warn("Cannot close zip input stream", new Object[]{e});
            }
        }
        return bl;
    }

    private Node createTopLevelNode(Node outputNode) throws RepositoryException {
        if (!outputNode.isNew()) {
            outputNode = outputNode.addNode("zip:content");
        }
        outputNode.setPrimaryType("zip:file");
        return outputNode;
    }

    private ZipEntry sequenceZipEntry(Node outputNode, Sequencer.Context context, ZipInputStream zipInputStream, ZipEntry entry) throws RepositoryException, IOException {
        Node zipEntryNode = this.createZipEntryPath(outputNode, entry);
        if (!entry.isDirectory()) {
            this.addFileContent(zipInputStream, entry, context, zipEntryNode);
        }
        return zipInputStream.getNextEntry();
    }

    private void addFileContent(ZipInputStream zipInputStream, ZipEntry entry, Sequencer.Context context, Node zipFileNode) throws RepositoryException, IOException {
        Node contentNode = zipFileNode.addNode("jcr:content", "nt:resource");
        contentNode.addMixin("mix:lastModified");
        byte[] contentBytes = this.readContent(zipInputStream);
        Binary contentBinary = context.valueFactory().createBinary(contentBytes);
        contentNode.setProperty("jcr:data", (javax.jcr.Binary)contentBinary);
        String mimeType = contentBinary.getMimeType(entry.getName());
        if (mimeType != null) {
            contentNode.setProperty("jcr:mimeType", mimeType);
        }
    }

    private byte[] readContent(ZipInputStream zipInputStream) throws IOException {
        int n;
        int bufferLength = 1024;
        byte[] buffer = new byte[bufferLength];
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        while ((n = zipInputStream.read(buffer, 0, bufferLength)) > -1) {
            baout.write(buffer, 0, n);
        }
        return baout.toByteArray();
    }

    private Node createZipEntryPath(Node parentNode, ZipEntry entry) throws RepositoryException {
        Node zipEntryNode = parentNode;
        String entryName = entry.getName();
        String[] segments = entryName.split("/");
        for (int i = 0; i < segments.length; ++i) {
            String segmentName = segments[i];
            try {
                zipEntryNode = zipEntryNode.getNode(segmentName);
                continue;
            }
            catch (PathNotFoundException e) {
                boolean isLastSegment;
                boolean bl = isLastSegment = i == segments.length - 1;
                String segmentPrimaryType = isLastSegment ? (entry.isDirectory() ? "nt:folder" : "nt:file") : "nt:folder";
                zipEntryNode = zipEntryNode.addNode(segmentName, segmentPrimaryType);
            }
        }
        return zipEntryNode;
    }

    public static final class MimeTypeConstants {
        public static final String JAR = "application/java-archive";
        public static final String ZIP = "application/zip";
    }
}

