/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.cmis;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Repository;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.jcr.JcrRepository;
import org.apache.chemistry.opencmis.jcr.JcrTypeManager;
import org.apache.chemistry.opencmis.jcr.PathManager;
import org.apache.chemistry.opencmis.jcr.impl.DefaultFolderTypeHandler;
import org.apache.chemistry.opencmis.jcr.impl.DefaultUnversionedDocumentTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandler;
import org.apache.chemistry.opencmis.jcr.type.JcrTypeHandlerManager;
import org.apache.chemistry.opencmis.server.support.CmisServiceWrapper;
import org.modeshape.cmis.JcrService;
import org.modeshape.cmis.MsDocumentTypeHandler;
import org.modeshape.cmis.RepositoryConfig;
import org.modeshape.common.logging.Logger;
import org.modeshape.web.jcr.NoSuchRepositoryException;
import org.modeshape.web.jcr.RepositoryManager;

public class JcrServiceFactory
extends AbstractServiceFactory {
    private static final Logger log = Logger.getLogger(JcrServiceFactory.class);
    public static final String MOUNT_PATH_CONFIG = "mount-path";
    public static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(50L);
    public static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(-1L);
    public static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(200L);
    public static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(10L);
    private static final String DEFAULT_MOUNT_PATH = "/";
    protected JcrTypeManager typeManager;
    protected Map<String, Map<String, String>> jcrConfig;
    protected String mountPath;
    private PathManager pathManager;
    private JcrTypeHandlerManager typeHandlerManager;

    public void init(Map<String, String> parameters) {
        this.readConfiguration(parameters);
        this.typeManager = new JcrTypeManager();
        this.pathManager = new PathManager(this.mountPath);
        this.typeHandlerManager = this.createTypeHandlerManager(this.pathManager, this.typeManager);
    }

    protected void init() {
        this.typeManager = new JcrTypeManager();
        this.pathManager = new PathManager(DEFAULT_MOUNT_PATH);
        this.typeHandlerManager = this.createTypeHandlerManager(this.pathManager, this.typeManager);
    }

    public void destroy() {
        this.typeManager = null;
        this.pathManager = null;
        this.typeHandlerManager = null;
        if (this.jcrConfig != null) {
            this.jcrConfig.clear();
            this.jcrConfig = null;
        }
    }

    public CmisService getService(CallContext context) {
        JcrService jcrService = this.createJcrService(this.loadRepositories(), context);
        CmisServiceWrapper serviceWrapper = new CmisServiceWrapper((CmisService)jcrService, DEFAULT_MAX_ITEMS_TYPES, DEFAULT_DEPTH_TYPES, DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_DEPTH_OBJECTS);
        ((JcrService)serviceWrapper.getWrappedService()).setCallContext(context);
        return serviceWrapper;
    }

    private Map<String, JcrRepository> loadRepositories() {
        HashMap<String, JcrRepository> list = new HashMap<String, JcrRepository>();
        Set names = RepositoryManager.getJcrRepositoryNames();
        for (String repositoryId : names) {
            try {
                Repository repository = RepositoryManager.getRepository((String)repositoryId);
                list.put(repositoryId, new JcrRepository(repository, this.pathManager, this.typeManager, this.typeHandlerManager));
                log.debug("--- loaded repository " + repositoryId, new Object[0]);
            }
            catch (NoSuchRepositoryException e) {}
        }
        return list;
    }

    protected JcrService createJcrService(Map<String, JcrRepository> jcrRepositories, CallContext context) {
        return new JcrService(jcrRepositories);
    }

    protected JcrTypeHandlerManager createTypeHandlerManager(PathManager pathManager, JcrTypeManager typeManager) {
        JcrTypeHandlerManager typeHandlerManager = new JcrTypeHandlerManager(pathManager, typeManager);
        typeHandlerManager.addHandler((JcrTypeHandler)new DefaultFolderTypeHandler());
        typeHandlerManager.addHandler((JcrTypeHandler)new MsDocumentTypeHandler());
        typeHandlerManager.addHandler((JcrTypeHandler)new DefaultUnversionedDocumentTypeHandler());
        return typeHandlerManager;
    }

    private void readConfiguration(Map<String, String> parameters) {
        String mountPath = parameters.get(MOUNT_PATH_CONFIG);
        this.mountPath = mountPath != null ? mountPath : DEFAULT_MOUNT_PATH;
        this.jcrConfig = RepositoryConfig.load(parameters);
    }
}

