/*
 * ModeShape (http://www.modeshape.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.modeshape.web.client;

import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;

/**
 *
 * @author kulikov
 */
public class PropsToolbar extends AbstractToolbar {
    
    public PropsToolbar(Console console) {
        super(console);
        
        //Add mixin
        button("", "icons/hcards_add.png", "Add mixin to the node", new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                console().addMixinDialog.showModal();
            }            
        });

        //Remove mixin
        button("", "icons/hcards_remove.png", "Remove mixin", new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                console().removeMixinDialog.showModal();
            }            
        });

        //Remove mixin
        button("", "icons/tag_add.png", "Add property", new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                console().addPropertyDialog.showModal();
            }            
        });
        
    }
}
