/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.server.impl;

import java.io.File;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.api.RepositoryManager;
import org.modeshape.jcr.api.Session;
import org.modeshape.jcr.api.Workspace;
import org.modeshape.web.client.RemoteException;
import org.modeshape.web.server.LRepository;

public class LRepositoryImpl
implements LRepository {
    private Credentials creds;
    private JcrRepository repository;
    private HashMap<String, javax.jcr.Session> sessions = new HashMap();
    private String[] workspaces;
    private static final Logger logger = Logger.getLogger(LRepositoryImpl.class);

    public LRepositoryImpl(JcrRepository repository, Credentials creds) throws RepositoryException {
        this.creds = creds;
        assert (repository != null);
        this.repository = repository;
        logger.debug("Logging to repository " + repository + " as " + creds, new Object[0]);
        JcrSession session = creds != null ? repository.login(creds) : repository.login();
        this.sessions.put(session.getWorkspace().getName(), session);
        this.workspaces = session.getWorkspace().getAccessibleWorkspaceNames();
        logger.debug("[" + this.repository.getName() + "] available workspaces " + this.wsnames(), new Object[0]);
    }

    public String name() {
        return this.repository.getName();
    }

    public String[] getWorkspaces() {
        logger.debug("[" + this.repository.getName() + "] Requested workspaces " + this.wsnames(), new Object[0]);
        return this.workspaces;
    }

    private String wsnames() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (int i = 0; i < this.workspaces.length - 1; ++i) {
            builder.append(this.workspaces[i]);
            builder.append(",");
        }
        builder.append(this.workspaces[this.workspaces.length - 1]);
        builder.append("}");
        return builder.toString();
    }

    public javax.jcr.Session session(String workspace) throws RemoteException {
        if (this.sessions.containsKey(workspace)) {
            logger.debug("[" + this.repository.getName() + "] has already session to " + workspace, new Object[0]);
            return (javax.jcr.Session)this.sessions.get(workspace);
        }
        try {
            logger.debug("[" + this.repository.getName() + "] has not yet session to " + workspace, new Object[0]);
            JcrSession session = this.creds != null ? this.repository.login(this.creds, workspace) : this.repository.login(workspace);
            this.sessions.put(workspace, session);
            return session;
        }
        catch (RepositoryException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public Repository repository() {
        return this.repository;
    }

    public void backup(String workspace, String name) throws RemoteException {
        try {
            File backupDir = new File(name);
            RepositoryManager mgr = ((Session)this.session(workspace)).getWorkspace().getRepositoryManager();
            mgr.backupRepository(backupDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
    }

    public void restore(String workspace, String name) throws RemoteException {
        try {
            File backupDir = new File(name);
            RepositoryManager mgr = ((Session)this.session(workspace)).getWorkspace().getRepositoryManager();
            mgr.restoreRepository(backupDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
    }

    public void importXML(String workspace) throws RemoteException {
        try {
            Workspace ws = ((Session)this.session(workspace)).getWorkspace();
            ws.importXML(workspace, null, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
    }
}

