/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.FormMethod;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.BackupDialog;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.RestoreDialog;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;

public class AdminView
extends View {
    private Console console;
    private BackupDialog backupDialog = new BackupDialog(this);
    private RestoreDialog restoreDialog = new RestoreDialog(this);
    private DynamicForm form = new DynamicForm();

    public AdminView(Console console, JcrServiceAsync jcrService, ViewPort viewPort) {
        super(viewPort, null);
        this.console = console;
        this.addMember((Canvas)new BackupControl());
        this.addMember((Canvas)new RestoreControl());
        this.addMember((Canvas)new DownloadControl());
        this.addMember((Canvas)this.form);
    }

    public void backup(String name) {
        this.console.jcrService.backup(this.console.repository(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }

    public void restore(String name) {
        this.console.jcrService.restore(this.console.repository(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }

    private void backupAndDownload() {
        this.console.jcrService.backup(this.console.contents().repository(), "zzz", new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                AdminView.this.form.setAction(GWT.getModuleBaseForStaticFiles() + "backup/do?file=zzz");
                AdminView.this.form.setMethod(FormMethod.GET);
                AdminView.this.form.submitForm();
            }
        });
    }

    private class DownloadControl
    extends VLayout {
        public DownloadControl() {
            this.setStyleName("admin-control");
            Label label = new Label("Backup & Download");
            label.setStyleName("button-label");
            label.setHeight(25);
            label.setIcon("icons/data.png");
            label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    AdminView.this.backupAndDownload();
                }
            });
            Canvas text = new Canvas();
            text.setAutoHeight();
            text.setContents("Create backups of an entire repository (even when the repository is in use) and download zip archive This works regardless of where the repository content is persisted.");
            this.addMember((Canvas)label);
            this.addMember(text);
        }
    }

    private class RestoreControl
    extends VLayout {
        public RestoreControl() {
            this.setStyleName("admin-control");
            Label label = new Label("Restore");
            label.setIcon("icons/documents.png");
            label.setStyleName("button-label");
            label.setHeight(25);
            label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    AdminView.this.restoreDialog.showModal();
                }
            });
            Canvas text = new Canvas();
            text.setAutoHeight();
            text.setContents("Once you have a complete backup on disk, you can then restore a repository back to the state captured within the backup. To do that, simply start a repository (or perhaps a new instance of a repository with a different configuration) and, before it\u2019s used by any applications, load into the new repository all of the content in the backup. ");
            this.addMember((Canvas)label);
            this.addMember(text);
        }
    }

    private class BackupControl
    extends VLayout {
        public BackupControl() {
            this.setStyleName("admin-control");
            Label label = new Label("Backup");
            label.setIcon("icons/data.png");
            label.setStyleName("button-label");
            label.setHeight(25);
            label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    AdminView.this.backupDialog.showModal();
                }
            });
            Canvas text = new Canvas();
            text.setAutoHeight();
            text.setContents("Create backups of an entire repository (even when the repository is in use)This works regardless of where the repository content is persisted.");
            this.addMember((Canvas)label);
            this.addMember(text);
        }
    }
}

