/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;
import org.modeshape.web.client.grid.NodeTypes;
import org.modeshape.web.shared.JcrNodeType;

public class NodeTypeView
extends View {
    private static final String HINT = "<p>Each node in a Modeshape workspace tree has a node type that defines the child nodes and properties it may (or must) have. Developers can use node types to define a custom content model for their application domain and have Modeshape enforce the constraints of that model at the repository level.</p>";
    private NodeTypes nodeTypes;
    private ComboBoxItem workspaces = new ComboBoxItem();
    private JcrServiceAsync jcrService;
    private String repository;

    public NodeTypeView(JcrServiceAsync jcrService, ViewPort viewPort) {
        super(viewPort, null);
        this.jcrService = jcrService;
        Canvas text = new Canvas();
        text.setContents(HINT);
        text.setWidth100();
        text.setAutoHeight();
        text.setStyleName("caption");
        this.nodeTypes = new NodeTypes();
        this.addMember(text);
        DynamicForm form = new DynamicForm();
        form.setFields(new FormItem[]{this.workspaces});
        this.workspaces.setTitle("Workspace");
        HLayout panel = new HLayout();
        panel.addMember((Canvas)form);
        panel.setStyleName("viewport");
        panel.setHeight(35);
        panel.setLayoutAlign(VerticalAlignment.CENTER);
        this.addMember((Canvas)panel);
        VLayout strut = new VLayout();
        strut.setHeight(20);
        this.addMember((Canvas)panel);
        this.addMember((Canvas)strut);
        this.addMember((Canvas)this.nodeTypes);
    }

    public void show(String repository) {
        this.repository = repository;
        this.jcrService.getWorkspaces(repository, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                NodeTypeView.this.workspaces.setValueMap(result);
                if (result.length > 0) {
                    NodeTypeView.this.workspaces.setValue(result[0]);
                }
                NodeTypeView.this.showTypes();
            }
        });
    }

    public void showTypes() {
        this.jcrService.nodeTypes(this.repository, this.workspaces.getValueAsString(), new AsyncCallback<Collection<JcrNodeType>>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Collection<JcrNodeType> result) {
                try {
                    NodeTypeView.this.nodeTypes.show(result);
                }
                catch (Exception e) {
                    SC.say((String)e.getMessage());
                }
                NodeTypeView.this.viewPort().display(NodeTypeView.this);
            }
        });
    }

    public void show(Collection<JcrNodeType> types) {
        this.nodeTypes.show(types);
    }
}

