/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.events.SubmitValuesEvent;
import com.smartgwt.client.widgets.form.events.SubmitValuesHandler;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.SubmitItem;
import com.smartgwt.client.widgets.form.fields.TextAreaItem;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;
import org.modeshape.web.shared.ResultSet;

public class QueryPanel
extends View {
    private static final String DEFAULT_LANG = "JCR-SQL2";
    private TextAreaItem queryEditor = new TextAreaItem();
    private SubmitItem execButton = new SubmitItem("Execute");
    private ListGrid grid = new ListGrid();
    private ComboBoxItem langBox = new ComboBoxItem();
    private Console console;

    public QueryPanel(Console console, JcrServiceAsync jcrService, ViewPort viewPort) {
        super(viewPort, null);
        this.setHeight(500);
        this.console = console;
        this.setStyleName("grid-bg");
        this.setLayoutMargin(1);
        VLayout background = new VLayout();
        background.setWidth100();
        background.setHeight100();
        background.setStyleName("grid-panel");
        this.addMember((Canvas)background);
        this.langBox.setTitle("Query language");
        DynamicForm queryForm = new DynamicForm();
        queryForm.setBackgroundColor("#d3d3d3");
        queryForm.setID("query-form");
        queryForm.setNumCols(3);
        this.queryEditor.setName("query");
        this.queryEditor.setTitle("Query");
        this.queryEditor.setStartRow(Boolean.valueOf(true));
        this.queryEditor.setEndRow(Boolean.valueOf(false));
        this.queryEditor.setWidth(500);
        this.execButton.setStartRow(Boolean.valueOf(false));
        this.execButton.setEndRow(Boolean.valueOf(true));
        queryForm.setItems(new FormItem[]{this.queryEditor, this.execButton, this.langBox});
        background.addMember((Canvas)queryForm);
        background.addMember((Canvas)this.grid);
        queryForm.addSubmitValuesHandler((SubmitValuesHandler)new ButtonClickHandler());
    }

    public void init() {
        this.console.jcrService.supportedQueryLanguages(this.console.contents().repository(), this.console.contents().workspace(), new SupportedLangsQueryHandler());
    }

    private String defaultLang(String[] options) {
        for (String option : options) {
            if (!option.toUpperCase().equals(DEFAULT_LANG)) continue;
            return option;
        }
        return "";
    }

    public class QueryResultHandler
    implements AsyncCallback<ResultSet> {
        public void onFailure(Throwable caught) {
            SC.say((String)caught.getMessage());
        }

        public void onSuccess(ResultSet rs) {
            String[] columnNames = rs.getColumnNames();
            ListGridField[] fields = new ListGridField[columnNames.length + 1];
            fields[0] = new ListGridField("icon", " ");
            fields[0].setCanEdit(Boolean.valueOf(false));
            fields[0].setImageURLPrefix("icons/bullet_");
            fields[0].setImageURLSuffix(".png");
            fields[0].setWidth(30);
            fields[0].setType(ListGridFieldType.IMAGE);
            for (int i = 1; i < fields.length; ++i) {
                fields[i] = new ListGridField(columnNames[i - 1], columnNames[i - 1]);
                fields[i].setCanEdit(Boolean.valueOf(false));
                fields[i].setShowHover(Boolean.valueOf(true));
            }
            Collection<String[]> rows = rs.getRows();
            ListGridRecord[] tbl = new ListGridRecord[rows.size()];
            int j = 0;
            for (String[] columns : rows) {
                ListGridRecord rec = new ListGridRecord();
                rec.setAttribute("icon", "blue");
                for (int i = 0; i < columns.length; ++i) {
                    rec.setAttribute(columnNames[i], columns[i]);
                }
                tbl[j++] = rec;
            }
            QueryPanel.this.grid.setFields(fields);
            QueryPanel.this.grid.setData(tbl);
            QueryPanel.this.grid.show();
        }
    }

    public class SupportedLangsQueryHandler
    implements AsyncCallback<String[]> {
        public void onFailure(Throwable caught) {
            SC.say((String)caught.getMessage());
        }

        public void onSuccess(String[] result) {
            QueryPanel.this.langBox.setValueMap(result);
            QueryPanel.this.langBox.setValue(QueryPanel.this.defaultLang(result));
            QueryPanel.this.console.display(QueryPanel.this);
        }
    }

    public class ButtonClickHandler
    implements SubmitValuesHandler {
        public void onSubmitValues(SubmitValuesEvent event) {
            ((QueryPanel)QueryPanel.this).console.jcrService.query(QueryPanel.this.console.contents().repository(), QueryPanel.this.console.contents().workspace(), QueryPanel.this.queryEditor.getEnteredValue(), QueryPanel.this.langBox.getEnteredValue(), new QueryResultHandler());
        }
    }
}

