/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.View;
import org.modeshape.web.client.ViewPort;
import org.modeshape.web.shared.RepositoryName;

public class RepositoriesView
extends View {
    private RepositoryItem[] items = new RepositoryItem[100];
    private JcrServiceAsync jcrService;
    private Console console;
    private String selected;

    public RepositoriesView(Console console, JcrServiceAsync jcrService, ViewPort viewPort) {
        super(viewPort, null);
        this.console = console;
        this.jcrService = jcrService;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new RepositoryItem();
            this.addMember((Canvas)this.items[i]);
        }
    }

    public String getSelected() {
        return this.selected;
    }

    public void show(Collection<RepositoryName> repos) {
        int i;
        for (i = 0; i < this.items.length; ++i) {
            this.items[i].setVisible(false);
        }
        i = 0;
        for (RepositoryName repo : repos) {
            this.items[i++].show(repo.getName(), repo.getDescriptor());
        }
    }

    public void load() {
        this.jcrService.getRepositories(new AsyncCallback<Collection<RepositoryName>>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Collection<RepositoryName> result) {
                try {
                    RepositoriesView.this.console.hideRepo();
                    RepositoriesView.this.show(result);
                    RepositoriesView.this.viewPort().display(RepositoriesView.this);
                }
                catch (Exception e) {
                    SC.say((String)e.getMessage());
                }
            }
        });
    }

    public void select(String repository, String workspace, String path, boolean changeHistory) {
        this.selected = repository;
        this.console.showContent(repository, workspace, path, changeHistory);
    }

    private class RepositoryItem
    extends VLayout {
        private Label name = new Label();
        private Canvas descriptor = new Label();

        public RepositoryItem() {
            this.setVisible(false);
            this.setStyleName("repository");
            this.name.setHeight(30);
            this.name.setStyleName("repository-name");
            this.name.setIcon("icons/logo-1.png");
            this.name.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Label repo = (Label)event.getSource();
                    RepositoriesView.this.selected = repo.getContents();
                    RepositoriesView.this.console.showContent(RepositoriesView.this.selected, true);
                }
            });
            this.addMember((Canvas)this.name);
            this.addMember(this.descriptor);
        }

        public void show(String name, String descriptor) {
            this.name.setContents(name);
            this.descriptor.setContents(descriptor);
            this.show();
        }
    }
}

