/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.grid;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Button;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import org.modeshape.web.client.Contents;
import org.modeshape.web.client.ExportDialog;
import org.modeshape.web.client.ImportDialog;
import org.modeshape.web.client.NewNodeDialog;
import org.modeshape.web.client.RenameNodeDialog;
import org.modeshape.web.client.grid.TabGrid;
import org.modeshape.web.shared.JcrNode;

public class Children
extends TabGrid<NodeRecord, JcrNode> {
    private JcrNode node;
    private final Contents contents;
    private final ExportDialog exportDialog;
    private final ImportDialog importDialog;
    private final NewNodeDialog newNodeDialog;
    private final RenameNodeDialog renameNodeDialog;

    public Children(Contents contents) {
        super("Child nodes");
        this.contents = contents;
        this.exportDialog = new ExportDialog(contents);
        this.importDialog = new ImportDialog(contents);
        this.newNodeDialog = new NewNodeDialog(contents);
        this.renameNodeDialog = new RenameNodeDialog(contents);
    }

    public void show(JcrNode node) {
        this.node = node;
        this.setValues(node.children());
    }

    @Override
    protected HLayout tableHeader() {
        HLayout header = new HLayout();
        header.setHeight(30);
        header.setBackgroundColor("#e6f1f6");
        Label name = new Label("<b>Name</b>");
        name.setWidth(150);
        name.setIcon("icons/view_tree_modernist.png");
        Label type = new Label("<b>Primary Type</b>");
        type.setWidth(150);
        type.setIcon("icons/documents.png");
        Label path = new Label("<b>Path</b>");
        path.setWidth100();
        path.setIcon("icons/view_table.png");
        header.addMember((Canvas)name);
        header.addMember((Canvas)type);
        header.addMember((Canvas)path);
        return header;
    }

    @Override
    protected HLayout toolBar() {
        HLayout header = new HLayout();
        header.setAlign(Alignment.LEFT);
        header.setBackgroundColor("#ffffff");
        header.setDefaultLayoutAlign(Alignment.LEFT);
        header.setLayoutAlign(Alignment.LEFT);
        header.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        header.setLayoutAlign(VerticalAlignment.CENTER);
        header.setHeight(30);
        HLayout panel = new HLayout();
        panel.setAlign(Alignment.RIGHT);
        panel.setWidth100();
        panel.setDefaultLayoutAlign(Alignment.RIGHT);
        panel.setLayoutAlign(Alignment.RIGHT);
        panel.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        panel.setLayoutAlign(VerticalAlignment.CENTER);
        Button addButton = new Button();
        addButton.setTitle("New node");
        addButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Children.this.getPrimaryTypesAndShowDialog();
            }
        });
        Button remButton = new Button();
        remButton.setTitle("Delete node");
        remButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                SC.ask((String)"Remove node", (String)"Do you want to remove node?", (BooleanCallback)new BooleanCallback(){

                    public void execute(Boolean confirmed) {
                        if (confirmed.booleanValue()) {
                            Children.this.contents.removeNode();
                        }
                    }
                });
            }
        });
        Button renameButton = new Button();
        renameButton.setTitle("Rename node");
        renameButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Children.this.renameNodeDialog.showModal();
            }
        });
        Button exportButton = new Button();
        exportButton.setTitle("Export");
        exportButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Children.this.exportDialog.showModal();
            }
        });
        Button importButton = new Button();
        importButton.setTitle("Import");
        importButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Children.this.importDialog.showModal();
            }
        });
        HLayout strut = new HLayout();
        strut.setWidth(5);
        header.addMember((Canvas)panel);
        panel.addMember((Canvas)new TabGrid.Strut(this, 10));
        panel.addMember((Canvas)addButton);
        panel.addMember((Canvas)new TabGrid.Strut(this, 5));
        panel.addMember((Canvas)remButton);
        panel.addMember((Canvas)new TabGrid.Strut(this, 5));
        panel.addMember((Canvas)renameButton);
        panel.addMember((Canvas)new TabGrid.Strut(this, 5));
        panel.addMember((Canvas)exportButton);
        panel.addMember((Canvas)new TabGrid.Strut(this, 5));
        panel.addMember((Canvas)importButton);
        return header;
    }

    protected void getPrimaryTypesAndShowDialog() {
        this.contents.jcrService().getPrimaryTypes(this.node.getRepository(), this.node.getWorkspace(), null, false, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Children.this.newNodeDialog.setPrimaryTypes(result);
                Children.this.newNodeDialog.showModal();
            }
        });
    }

    protected NodeRecord[] records() {
        NodeRecord[] recs = new NodeRecord[100];
        for (int i = 0; i < recs.length; ++i) {
            recs[i] = new NodeRecord();
        }
        return recs;
    }

    @Override
    protected void updateRecord(int pos, NodeRecord record, JcrNode value) {
        if (this.node.getPath().equals("/")) {
            record.setNode(value);
        } else if (pos == -1) {
            record.setNodeAsParent(this.node);
        } else if (pos == 0) {
            record.setNodeAsParent(this.node);
        } else {
            record.setNode(value);
        }
    }

    public class NodeRecord
    extends HLayout {
        private Label name = new Label();
        private Label path = new Label();
        private Label primaryType = new Label();
        private JcrNode node;

        public NodeRecord() {
            this.setStyleName("grid");
            this.setHeight(30);
            this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
            this.setDefaultLayoutAlign(Alignment.LEFT);
            this.setLayoutAlign(VerticalAlignment.CENTER);
            this.setLayoutAlign(Alignment.CENTER);
            this.setAlign(VerticalAlignment.CENTER);
            this.setAlign(Alignment.LEFT);
            this.name.setStyleName("node-name");
            this.name.setIcon("icons/folder.png");
            this.name.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Children.this.contents.getAndDisplayNode(NodeRecord.this.path(), true);
                }
            });
            this.name.setWidth(150);
            this.primaryType.setWidth(150);
            this.primaryType.setStyleName("text");
            this.path.setWidth100();
            this.path.setStyleName("text");
            this.addMember((Canvas)this.name);
            this.addMember((Canvas)this.primaryType);
            this.addMember((Canvas)this.path);
        }

        private String path() {
            return this.node == null ? "/" : this.path.getContents();
        }

        private void setNode(JcrNode node) {
            this.node = node;
            this.name.setContents(node.getName());
            this.path.setContents(node.getPath());
            this.path.setVisible(true);
            this.primaryType.setContents(node.getPrimaryType());
        }

        private void setNodeAsParent(JcrNode node) {
            this.node = node;
            this.name.setContents("<b>../</b>");
            this.path.setContents(this.parent(node.getPath()));
            this.path.setVisible(false);
            this.primaryType.setContents("");
        }

        private String parent(String path) {
            if (path == null) {
                return "/";
            }
            if ((path = path.substring(0, path.lastIndexOf(47))).length() == 0) {
                return "/";
            }
            return path;
        }
    }
}

