/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.contents;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.layout.HLayout;
import org.modeshape.web.client.contents.AddPolicyDialog;
import org.modeshape.web.client.contents.Contents;
import org.modeshape.web.client.grid.BooleanField;
import org.modeshape.web.client.grid.TabGrid;
import org.modeshape.web.shared.Columns;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrPermission;
import org.modeshape.web.shared.Policy;

public class PermissionsEditor
extends TabGrid<AclRecord, JcrPermission> {
    private final Policy ALL_PERMISSIONS_FOR_EVERYONE = new Policy();
    private static final int HEADER_HEIGHT = 30;
    protected final Contents contents;
    private JcrNode node;
    private ComboBoxItem principal;
    protected AddPolicyDialog addPolicyDialog;

    public PermissionsEditor(Contents contents) {
        super("");
        this.contents = contents;
        for (JcrPermission p : this.ALL_PERMISSIONS_FOR_EVERYONE.permissions()) {
            p.setStatus(true);
        }
        this.addPolicyDialog = new AddPolicyDialog(contents);
    }

    public void show(JcrNode node) {
        this.node = node;
        if (this.isAclDefined(node)) {
            this.selectFirstPrincipalAndDisplayPermissions(node);
        } else {
            this.displayEveryonePermissions();
        }
    }

    protected AclRecord[] records() {
        int n = new Policy().permissions().size();
        AclRecord[] records = new AclRecord[n];
        for (int i = 0; i < n; ++i) {
            records[i] = new AclRecord();
        }
        return records;
    }

    @Override
    protected HLayout tableHeader() {
        HLayout layout = new HLayout();
        layout.setHeight(30);
        layout.setWidth100();
        layout.setBackgroundColor("#e6f1f6");
        Label name = new Label("<b>Permission</b>");
        name.setWidth100();
        Label type = new Label("<b>Status</b>");
        type.setWidth(50);
        layout.addMember((Canvas)name);
        layout.addMember((Canvas)type);
        return layout;
    }

    @Override
    protected HLayout toolBar() {
        Columns layout = new Columns(1, 5);
        layout.setBackgroundColor("#ffffff");
        layout.setHeight(30);
        layout.setWidth100();
        DynamicForm form = new DynamicForm();
        form.setWidth100();
        layout.addMember((Canvas)form);
        this.principal = new ComboBoxItem("Principal");
        this.principal.setWidth("100%");
        form.setItems(new FormItem[]{this.principal});
        Label addPrincipalButton = new Label();
        addPrincipalButton.setStyleName("button-label");
        addPrincipalButton.setWidth(16);
        addPrincipalButton.setHeight(16);
        addPrincipalButton.setIcon("icons/group_blue_add.png");
        addPrincipalButton.setTooltip("Add new principal name");
        addPrincipalButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PermissionsEditor.this.addPrincipal();
            }
        });
        layout.addMember((Canvas)addPrincipalButton);
        Label delPrincipalButton = new Label();
        delPrincipalButton.setStyleName("button-label");
        delPrincipalButton.setWidth(16);
        delPrincipalButton.setHeight(16);
        delPrincipalButton.setIcon("icons/group_blue_remove.png");
        delPrincipalButton.setTooltip("Delete this principal");
        delPrincipalButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                PermissionsEditor.this.delPrincipal();
            }
        });
        layout.addMember((Canvas)delPrincipalButton);
        return layout;
    }

    private void addPrincipal() {
        this.addPolicyDialog.showModal();
    }

    private void delPrincipal() {
        SC.ask((String)("Do you want to delete principal " + this.principal.getValueAsString()), (BooleanCallback)new BooleanCallback(){

            public void execute(Boolean status) {
                if (status.booleanValue()) {
                    PermissionsEditor.this.contents.removeAccessList(PermissionsEditor.this.principal.getValueAsString());
                }
            }
        });
    }

    @Override
    protected void updateRecord(int pos, AclRecord record, JcrPermission value) {
        record.name.setContents(value.getDisplayName());
        record.value.setValue(value.getStatus());
        record.permission = value;
    }

    private boolean isAclDefined(JcrNode node) {
        return node.getAcl() != null && node.getAcl().principals().length != 0;
    }

    private void displayEveryonePermissions() {
        this.principal.setValueMap(new String[]{"Everyone"});
        this.principal.setValue("Everyone");
        this.setValues(this.ALL_PERMISSIONS_FOR_EVERYONE.permissions());
    }

    private void selectFirstPrincipalAndDisplayPermissions(JcrNode node) {
        String[] principals = node.getAcl().principals();
        this.principal.setValueMap(principals);
        this.principal.setValue(principals[0]);
        this.setValues(node.getAcl().getPolicy(principals[0]).permissions());
    }

    public class AclRecord
    extends HLayout {
        private JcrPermission permission;
        private Label name = new Label();
        private BooleanField value = new BooleanField();

        public AclRecord() {
            this.setStyleName("grid");
            this.setHeight(30);
            this.setWidth100();
            this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
            this.setDefaultLayoutAlign(Alignment.LEFT);
            this.setLayoutAlign(VerticalAlignment.CENTER);
            this.setLayoutAlign(Alignment.CENTER);
            this.setAlign(VerticalAlignment.CENTER);
            this.setAlign(Alignment.LEFT);
            this.name.setIcon("icons/shield.png");
            this.name.setStyleName("text");
            this.name.setWidth100();
            this.value.setWidth(50);
            this.value.setStyleName("button-label");
            this.value.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    AclRecord.this.changePermission();
                }
            });
            this.addMember((Canvas)this.name);
            this.addMember((Canvas)this.value);
        }

        private void changePermission() {
            if (PermissionsEditor.this.node.getAcl() == null) {
                return;
            }
            this.permission.setStatus(!this.permission.getStatus());
            PermissionsEditor.this.contents.updateAccessList(PermissionsEditor.this.principal.getValueAsString(), this.permission, this.permission.getStatus());
        }
    }
}

