/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.grid;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.grid.TabGrid;

public class TabsetGrid
extends VLayout {
    private final TabGrid<?, ?>[] tabs;
    private Label[] labels;

    public TabsetGrid(String[] caption, TabGrid<?, ?>[] tbs) {
        this.tabs = tbs;
        this.init(caption);
    }

    private void init(String ... caption) {
        int i;
        this.setStyleName("grid-bg");
        this.setLayoutMargin(1);
        VLayout background = new VLayout();
        background.setWidth100();
        background.setHeight100();
        background.setStyleName("grid-panel");
        this.addMember((Canvas)background);
        HLayout topPanel = new HLayout();
        topPanel.setHeight(30);
        topPanel.setAlign(VerticalAlignment.CENTER);
        topPanel.setAlign(Alignment.LEFT);
        topPanel.setLayoutMargin(Integer.valueOf(3));
        topPanel.setBackgroundColor("#e6f1f6");
        this.labels = new Label[this.tabs.length];
        for (i = 0; i < this.tabs.length; ++i) {
            Label label = new Label(caption[i]);
            label.setDataPath(Integer.toString(i));
            label.setStyleName("caption");
            label.setWidth(100);
            label.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Label l = (Label)event.getSource();
                    int i = Integer.parseInt(l.getDataPath());
                    TabsetGrid.this.showTab(i);
                }
            });
            this.labels[i] = label;
            topPanel.addMember((Canvas)label);
        }
        background.addMember((Canvas)topPanel);
        for (i = 0; i < this.tabs.length; ++i) {
            background.addMember(this.tabs[i]);
        }
        this.setAutoHeight();
        HLayout bottomPanel = new HLayout();
        bottomPanel.setHeight(30);
        bottomPanel.setBackgroundColor("#e6f1f6");
        background.addMember((Canvas)bottomPanel);
        this.showTab(0);
    }

    public void showTab(int k) {
        int i;
        for (i = 0; i < this.tabs.length; ++i) {
            this.tabs[i].setVisible(i == k);
        }
        for (i = 0; i < this.labels.length; ++i) {
            if (i == k) {
                this.labels[i].setStyleName("caption-selected");
                continue;
            }
            this.labels[i].setStyleName("caption");
        }
    }

    protected class Strut
    extends HLayout {
        public Strut(int size) {
            this.setWidth(size);
        }
    }
}

