/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.query;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.ListGridFieldType;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.events.SubmitValuesEvent;
import com.smartgwt.client.widgets.form.events.SubmitValuesHandler;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.SubmitItem;
import com.smartgwt.client.widgets.form.fields.TextAreaItem;
import com.smartgwt.client.widgets.grid.ListGrid;
import com.smartgwt.client.widgets.grid.ListGridField;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import java.util.Collection;
import org.modeshape.web.client.Console;
import org.modeshape.web.shared.Form;
import org.modeshape.web.shared.ResultSet;

public class QueryForm
extends Form {
    private static final String DEFAULT_LANG = "JCR-SQL2";
    private final TextAreaItem queryEditor = new TextAreaItem();
    private final SubmitItem execButton = new SubmitItem("Execute");
    private final ComboBoxItem langBox = new ComboBoxItem("Query language");
    private final ListGrid grid = new ListGrid();
    private final Console console;

    public QueryForm(final Console console) {
        this.console = console;
        this.setWidth100();
        this.grid.setWidth100();
        this.grid.setHeight(380);
        DynamicForm queryForm = new DynamicForm();
        queryForm.setBackgroundColor("#e6f1f6");
        queryForm.setID("query-form-1");
        queryForm.setNumCols(3);
        this.queryEditor.setName("query");
        this.queryEditor.setTitle("Query");
        this.queryEditor.setStartRow(Boolean.valueOf(true));
        this.queryEditor.setEndRow(Boolean.valueOf(false));
        this.queryEditor.setWidth(500);
        this.execButton.setStartRow(Boolean.valueOf(false));
        this.execButton.setEndRow(Boolean.valueOf(true));
        queryForm.setItems(new FormItem[]{this.queryEditor, this.execButton, this.langBox});
        queryForm.addSubmitValuesHandler(new SubmitValuesHandler(){

            public void onSubmitValues(SubmitValuesEvent event) {
                console.jcrService().query(console.contents().repository(), console.contents().workspace(), QueryForm.this.queryEditor.getEnteredValue(), QueryForm.this.langBox.getEnteredValue(), new AsyncCallback<ResultSet>(){

                    public void onFailure(Throwable caught) {
                        SC.say((String)caught.getMessage());
                    }

                    public void onSuccess(ResultSet data) {
                        QueryForm.this.displayResultSet(data);
                    }
                });
            }
        });
        this.addMember((Canvas)queryForm);
        this.addMember((Canvas)this.grid);
    }

    private void displayResultSet(ResultSet rs) {
        String[] columnNames = rs.getColumnNames();
        ListGridField[] fields = new ListGridField[columnNames.length + 1];
        fields[0] = new ListGridField("icon", " ");
        fields[0].setCanEdit(Boolean.valueOf(false));
        fields[0].setImageURLPrefix("icons/bullet_");
        fields[0].setImageURLSuffix(".png");
        fields[0].setWidth(30);
        fields[0].setType(ListGridFieldType.IMAGE);
        for (int i = 1; i < fields.length; ++i) {
            fields[i] = new ListGridField(columnNames[i - 1], columnNames[i - 1]);
            fields[i].setCanEdit(Boolean.valueOf(false));
            fields[i].setShowHover(Boolean.valueOf(true));
        }
        this.grid.setFields(fields);
        Collection<String[]> rows = rs.getRows();
        ListGridRecord[] tbl = new ListGridRecord[rows.size()];
        int j = 0;
        for (String[] columns : rows) {
            ListGridRecord rec = new ListGridRecord();
            rec.setAttribute("icon", "blue");
            for (int i = 0; i < columns.length; ++i) {
                rec.setAttribute(columnNames[i], columns[i]);
            }
            tbl[j++] = rec;
        }
        this.grid.setData(tbl);
        this.grid.show();
    }

    @Override
    public void init() {
        this.console.jcrService().supportedQueryLanguages(this.console.contents().repository(), this.console.contents().workspace(), new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                QueryForm.this.langBox.setValueMap(result);
                QueryForm.this.langBox.setValue(QueryForm.this.defaultLang(result));
            }
        });
    }

    private String defaultLang(String[] options) {
        for (String option : options) {
            if (!option.toUpperCase().equals(DEFAULT_LANG)) continue;
            return option;
        }
        return "";
    }
}

