/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.modeshape.web.shared.JcrPermission;

public class JcrPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String principal;
    private ArrayList<JcrPermission> permissions = new ArrayList();

    public static JcrPolicy everyone() {
        return new JcrPolicy("EVERYONE");
    }

    public JcrPolicy() {
    }

    public JcrPolicy(String principal) {
        this.principal = principal;
        this.permissions.add(JcrPermission.ALL);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void add(JcrPermission permission) {
        this.permissions.add(permission);
    }

    public void remove(JcrPermission permission) {
        this.permissions.remove(permission);
    }

    public Collection<JcrPermission> getPermissions() {
        return this.permissions;
    }

    public void update(String action, String value) {
        Boolean enable = value.equals("Allow");
        if (enable.booleanValue()) {
            this.permissions.add(JcrPermission.fromDisplayName(action));
        } else {
            JcrPermission p = this.find(action);
            this.permissions.remove(p);
        }
    }

    private JcrPermission find(String name) {
        JcrPermission permission = JcrPermission.fromDisplayName(name);
        for (JcrPermission p : this.permissions) {
            if (!permission.getName().equals(p.getName())) continue;
            return p;
        }
        return null;
    }
}

