/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.modeshape.common.logging.Logger;
import org.modeshape.web.BinaryContentServlet;
import org.modeshape.web.server.Connector;

public class BinaryContentUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1505304380334878522L;
    private static final String CONTENT_PARAMETER = "Upload content";
    private static final String REPOSITORY_NAME_PARAMETER = "repository";
    private static final String WORKSPACE_NAME_PARAMETER = "workspace";
    private static final String NODE_PATH_PARAMETER = "path";
    private static final String PROPERTY_NAME_PARAMETER = "pname";
    private static final String REPOSITORY_CONNECTOR = "connector";
    private static final String MIME_TYPE = "jcr:mimeType";
    private static final String DESTINATION_URL = "/tree/%s/ws-%s%s";
    private ServletFileUpload upload;
    private final Logger logger = Logger.getLogger(BinaryContentServlet.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        List items;
        try {
            items = this.upload.parseRequest(request);
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
        String repository = this.getParameter(items, REPOSITORY_NAME_PARAMETER);
        String workspace = this.getParameter(items, WORKSPACE_NAME_PARAMETER);
        String path = this.getParameter(items, NODE_PATH_PARAMETER);
        String pname = this.getParameter(items, PROPERTY_NAME_PARAMETER);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Upload %s at %s/%s%s", pname, repository, workspace, path), new Object[0]);
        }
        String mimeType = this.getContentType(items);
        Connector connector = (Connector)request.getSession().getAttribute(REPOSITORY_CONNECTOR);
        try {
            Session session = connector.find(repository).session(workspace);
            ValueFactory valueFactory = session.getValueFactory();
            Binary bin = valueFactory.createBinary(this.getStream(items));
            Node node = session.getNode(path);
            node.setProperty(pname, bin);
            node.setProperty(MIME_TYPE, mimeType);
            bin.dispose();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        String uri = request.getContextPath() + String.format(DESTINATION_URL, repository, workspace, path);
        response.sendRedirect(uri);
    }

    private String getParameter(List<FileItem> items, String name) {
        for (FileItem i : items) {
            if (!i.isFormField() || !i.getFieldName().equals(name)) continue;
            return i.getString();
        }
        return null;
    }

    private InputStream getStream(List<FileItem> items) throws IOException {
        for (FileItem i : items) {
            if (i.isFormField() || !i.getFieldName().equals(CONTENT_PARAMETER)) continue;
            return i.getInputStream();
        }
        return null;
    }

    private String getContentType(List<FileItem> items) {
        for (FileItem i : items) {
            if (i.isFormField() || !i.getFieldName().equals(CONTENT_PARAMETER)) continue;
            return i.getContentType();
        }
        return null;
    }

    public void init() {
        DiskFileItemFactory diskFactory = new DiskFileItemFactory();
        ServletContext servletContext = this.getServletConfig().getServletContext();
        File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        diskFactory.setRepository(tempDir);
        this.upload = new ServletFileUpload((FileItemFactory)diskFactory);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

