/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.types.FormMethod;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.HiddenItem;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.admin.AdminView;
import org.modeshape.web.client.admin.BackupOptionsDialog;
import org.modeshape.web.shared.BackupParams;

public class BackupDownloadControl
extends VLayout {
    private final DynamicForm form = new DynamicForm();
    private final HiddenItem fileField = new HiddenItem("file");
    private final AdminView adminView;
    private final BackupOptionsDialog optionsDialog = new BackupOptionsDialog(this);

    public BackupDownloadControl(AdminView adminView) {
        this.adminView = adminView;
        this.setStyleName("admin-control");
        this.form.setItems(new FormItem[]{this.fileField});
        Label label = new Label("Backup & Download");
        label.setStyleName("button-label");
        label.setHeight(25);
        label.setIcon("icons/data.png");
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                BackupDownloadControl.this.optionsDialog.showModal();
            }
        });
        Canvas text = new Canvas();
        text.setAutoHeight();
        text.setContents("Create backups of an entire repository (even when the repository is in use) and download zip archive This works regardless of where the repository content is persisted.");
        this.addMember((Canvas)label);
        this.addMember(text);
        this.addMember((Canvas)this.form);
    }

    protected void backupAndDownload(BackupParams params) {
        final String name = Long.toString(System.currentTimeMillis());
        this.fileField.setValue(name);
        this.adminView.jcrService().backup(this.adminView.repository(), name, params, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                BackupDownloadControl.this.form.setAction(GWT.getModuleBaseForStaticFiles() + "backup/da?file=" + name);
                BackupDownloadControl.this.form.setMethod(FormMethod.GET);
                BackupDownloadControl.this.form.submitForm();
            }
        });
    }
}

